"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SurveyKubernetes = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KUBERNETES_TOAST_STORAGE_KEY = 'kubernetesToastKey';
const KUBERNETES_FEEDBACK_LINK = 'https://ela.st/k8s-feedback';
const SurveyKubernetes = () => {
  const [isToastSeen, setIsToastSeen] = (0, _useLocalStorage.default)(KUBERNETES_TOAST_STORAGE_KEY, false);
  const markToastAsSeen = () => setIsToastSeen(true);
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = (0, _use_kibana.useKibanaEnvironmentContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
    formUrl: KUBERNETES_FEEDBACK_LINK,
    "data-test-subj": "infra-kubernetes-feedback-link",
    kibanaVersion: kibanaVersion,
    isCloudEnv: isCloudEnv,
    isServerlessEnv: isServerlessEnv,
    surveyButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.homePage.tellUsWhatYouThinkK8sLink",
      defaultMessage: "Tell us what you think! (K8s)"
    }),
    sanitizedPath: document.location.pathname
  }), !isToastSeen && /*#__PURE__*/_react.default.createElement(_eui.EuiGlobalToastList, {
    toastLifeTimeMs: Infinity,
    dismissToast: markToastAsSeen,
    toasts: [{
      id: 'k8s-toast',
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.homePage.kubernetesToastTitle",
        defaultMessage: "We need your help!"
      }),
      color: 'primary',
      iconType: 'help',
      text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.homePage.kubernetesToastText",
        defaultMessage: "Help us design your Kubernetes experience by completing a feedback survey."
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexEnd",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
        formUrl: KUBERNETES_FEEDBACK_LINK,
        "data-test-subj": "infra-toast-kubernetes-survey-start",
        onClickCapture: markToastAsSeen,
        defaultButton: true,
        kibanaVersion: kibanaVersion,
        isCloudEnv: isCloudEnv,
        isServerlessEnv: isServerlessEnv,
        surveyButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.homePage.kubernetesToastButton",
          defaultMessage: "Start survey"
        }),
        sanitizedPath: document.location.pathname
      }))))
    }]
  }));
};
exports.SurveyKubernetes = SurveyKubernetes;