"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _api_privileges = require("../../constants/api_privileges");
var _errors = require("../schema/errors");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // Rotate fleet message signing key pair
  router.versioned.post({
    path: _constants2.MESSAGE_SIGNING_SERVICE_API_ROUTES.ROTATE_KEY_PAIR,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL, _api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    },
    summary: 'Rotate a Fleet message signing key pair',
    options: {
      tags: ['oas-tag:Message Signing Service']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.RotateKeyPairSchema,
      response: {
        200: {
          body: () => _configSchema.schema.object({
            message: _configSchema.schema.string()
          })
        },
        400: {
          body: _errors.genericErrorResponse
        },
        500: {
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handlers.rotateKeyPairHandler);
};
exports.registerRoutes = registerRoutes;