"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlParams = useUrlParams;
var _reactRouterDom = require("react-router-dom");
var _queryString = require("query-string");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Parses `search` params and returns an object with them along with a `toUrlParams` function
 * that allows being able to retrieve a stringified version of an object (default is the
 * `urlParams` that was parsed) for use in the url.
 * Object will be recreated every time `search` changes.
 */
function useUrlParams() {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const [urlParams, setUrlParams] = (0, _react.useState)(() => (0, _queryString.parse)(search));
  const toUrlParams = (0, _react.useCallback)((params = urlParams, options) => (0, _queryString.stringify)(params, options), [urlParams]);
  (0, _react.useEffect)(() => {
    setUrlParams((0, _queryString.parse)(search));
  }, [search]);
  return {
    urlParams,
    toUrlParams
  };
}