"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentExportCSVTour = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentExportCSVTour = () => {
  const {
    isOpen,
    dismiss
  } = (0, _hooks.useDismissableTour)('AGENT_EXPORT_CSV');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentExportCSVTour.tourContent",
      defaultMessage: "Once you have selected the agents, click the action menu to download the CSV file."
    })),
    isStepOpen: isOpen,
    onFinish: dismiss,
    minWidth: 360,
    maxWidth: 360,
    step: 1,
    stepsTotal: 1,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentExportCSVTour.tourTitle",
      defaultMessage: "Download CSV file"
    }),
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: dismiss
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.genericTourPopover.dismissButton",
      defaultMessage: "Got it"
    })),
    anchorPosition: "upLeft",
    anchor: "#agentListSelectionText"
  }));
};
exports.AgentExportCSVTour = AgentExportCSVTour;