"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointsHeaderAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _connection_details = require("@kbn/cloud/connection_details");
var _i18n = require("@kbn/i18n");
var _endpoint_icon = require("./endpoint_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointsHeaderAction = ({
  children
}) => {
  const [open, setOpen] = _react.default.useState(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, !!children && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: _endpoint_icon.EndpointIcon,
    size: "s",
    onClick: () => setOpen(x => !x),
    "data-test-subj": "enterpriseSearchEndpointsHeaderActionEndpointsApiKeysButton"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.pageTemplate.endpointsButtonLabel', {
    defaultMessage: 'Endpoints & API keys'
  })))), open && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setOpen(false),
    size: 's'
  }, /*#__PURE__*/_react.default.createElement(_connection_details.KibanaWiredConnectionDetailsProvider, null, /*#__PURE__*/_react.default.createElement(_connection_details.ConnectionDetailsFlyoutContent, null))));
};
exports.EndpointsHeaderAction = EndpointsHeaderAction;