"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostAttackDiscoveryBulkResponse = exports.PostAttackDiscoveryBulkRequestBody = void 0;
var _zod = require("@kbn/zod");
var _attack_discovery_alert = require("./attack_discovery_alert.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Attack discovery bulk API
 *   version: 1
 */

const PostAttackDiscoveryBulkRequestBody = exports.PostAttackDiscoveryBulkRequestBody = _zod.z.object({
  /**
   * Parameters for the bulk API
   */
  update: _zod.z.object({
    /**
     * The IDs of the Attack discovery alerts to update
     */
    ids: _zod.z.array(_zod.z.string()),
    /**
     * When provided, update the kibana.alert.workflow_status of the attack discovery alerts
     */
    kibana_alert_workflow_status: _zod.z.enum(['open', 'acknowledged', 'closed']).optional(),
    /**
     * When provided, update the visibility of the alert, as determined by the kibana.alert.attack_discovery.users field
     */
    visibility: _zod.z.enum(['not_shared', 'shared']).optional()
  }).optional()
});
const PostAttackDiscoveryBulkResponse = exports.PostAttackDiscoveryBulkResponse = _zod.z.object({
  data: _zod.z.array(_attack_discovery_alert.AttackDiscoveryAlert)
});