"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.datasetQualityPrivileges = void 0;
var _boom = require("@hapi/boom");
var _utils = require("../../common/utils");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DatasetQualityPrivileges {
  async getHasIndexPrivileges(esClient, indexes, privileges) {
    const indexPrivileges = await esClient.security.hasPrivileges({
      index: indexes.map(dataStream => ({
        names: dataStream,
        privileges
      }))
    });
    return indexPrivileges.index;
  }
  async getCanViewIntegrations(esClient, space = '*') {
    var _applicationPrivilege, _applicationPrivilege2, _applicationPrivilege3, _applicationPrivilege4;
    const applicationPrivileges = await esClient.security.hasPrivileges({
      application: [{
        application: 'kibana-.kibana',
        privileges: ['feature_fleet.read'],
        resources: [space]
      }]
    });
    return (_applicationPrivilege = (_applicationPrivilege2 = applicationPrivileges.application) === null || _applicationPrivilege2 === void 0 ? void 0 : (_applicationPrivilege3 = _applicationPrivilege2['kibana-.kibana']) === null || _applicationPrivilege3 === void 0 ? void 0 : (_applicationPrivilege4 = _applicationPrivilege3[space]) === null || _applicationPrivilege4 === void 0 ? void 0 : _applicationPrivilege4['feature_fleet.read']) !== null && _applicationPrivilege !== void 0 ? _applicationPrivilege : false;
  }
  async getDatasetPrivileges(esClient, dataset, space = '*') {
    const indexPrivileges = await this.getHasIndexPrivileges(esClient, dataset, ['read', 'monitor', 'view_index_metadata', _constants.FAILURE_STORE_PRIVILEGE]);
    const datasetsPrivilages = Object.fromEntries(Object.entries(indexPrivileges).map(([index, privileges]) => [index, {
      canRead: privileges.read,
      canMonitor: privileges.view_index_metadata,
      canReadFailureStore: privileges[_constants.FAILURE_STORE_PRIVILEGE]
    }]));
    const canViewIntegrations = await this.getCanViewIntegrations(esClient, space);
    return {
      datasetsPrivilages,
      canViewIntegrations
    };
  }
  async canReadDataset(esClient, type = _constants.DEFAULT_DATASET_TYPE, datasetQuery = '*-*', space = '*') {
    const datasetName = (0, _utils.streamPartsToIndexPattern)({
      typePattern: type,
      datasetPattern: datasetQuery
    });
    const datasetUserPrivileges = await datasetQualityPrivileges.getDatasetPrivileges(esClient, [datasetName], space);
    return datasetUserPrivileges.datasetsPrivilages[datasetName].canRead;
  }
  async throwIfCannotReadDataset(esClient, type = _constants.DEFAULT_DATASET_TYPE, datasetQuery = '*-*', space = '*') {
    if (!(await this.canReadDataset(esClient, type, datasetQuery, space))) {
      const datasetName = (0, _utils.streamPartsToIndexPattern)({
        typePattern: type,
        datasetPattern: datasetQuery
      });
      throw (0, _boom.forbidden)(`Unauthorized to read dataset ${datasetName}`);
    }
  }
}
const datasetQualityPrivileges = exports.datasetQualityPrivileges = new DatasetQualityPrivileges();