"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMigrationHash = void 0;
var _crypto = require("crypto");
var _extract_migration_info = require("./extract_migration_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getMigrationHash = soType => {
  var _migInfo$convertToAli, _migInfo$convertToMul, _migInfo$switchToMode;
  const migInfo = (0, _extract_migration_info.extractMigrationInfo)(soType);
  const hash = (0, _crypto.createHash)('sha1'); // eslint-disable-line @kbn/eslint/no_unsafe_hash

  const hashParts = [migInfo.name, migInfo.namespaceType, (_migInfo$convertToAli = migInfo.convertToAliasScript) !== null && _migInfo$convertToAli !== void 0 ? _migInfo$convertToAli : 'none', migInfo.hasExcludeOnUpgrade, (_migInfo$convertToMul = migInfo.convertToMultiNamespaceTypeVersion) !== null && _migInfo$convertToMul !== void 0 ? _migInfo$convertToMul : 'none', migInfo.migrationVersions.join(','), migInfo.schemaVersions.join(','), JSON.stringify(migInfo.mappings, Object.keys(migInfo.mappings).sort()), (_migInfo$switchToMode = migInfo.switchToModelVersionAt) !== null && _migInfo$switchToMode !== void 0 ? _migInfo$switchToMode : 'none', migInfo.modelVersions.map(serializeModelVersion).join(',')];
  const hashFeed = hashParts.join('-');
  return hash.update(hashFeed).digest('hex');
};
exports.getMigrationHash = getMigrationHash;
const serializeModelVersion = modelVersion => {
  const schemas = [modelVersion.schemas.forwardCompatibility];
  return [modelVersion.version, modelVersion.changeTypes.join(','), modelVersion.hasTransformation, schemas.join(','), ...modelVersion.newMappings].join('|');
};