"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusCodeDecorations = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getStatusCodeClassNameSuffix = statusCode => {
  if (statusCode <= 199) {
    return '--default';
  }
  if (statusCode <= 299) {
    return '--success';
  }
  if (statusCode <= 399) {
    return '--primary';
  }
  if (statusCode <= 499) {
    return '--warning';
  }
  return '--danger';
};
const getStatusCodeDecorations = data => {
  const decorations = [];
  let lastResponseEndLine = 0;
  data.forEach(({
    response
  }) => {
    if (response !== null && response !== void 0 && response.value) {
      const range = {
        startLineNumber: lastResponseEndLine + 1,
        startColumn: 1,
        endLineNumber: lastResponseEndLine + 1,
        endColumn: 1 // It doesn't matter what endColumn we set as the decoration will be applied to the whole line
      };
      const classNameSuffix = getStatusCodeClassNameSuffix(response.statusCode);
      decorations.push({
        range,
        options: {
          isWholeLine: true,
          blockClassName: `${_constants.STATUS_CODE_LINE_CLASSNAME}${classNameSuffix}`,
          marginClassName: `${_constants.STATUS_CODE_LINE_CLASSNAME}_number${classNameSuffix}`
        }
      });
      lastResponseEndLine += response.value.split(/\\n|\n/).length;
    }
  });
  return decorations;
};
exports.getStatusCodeDecorations = getStatusCodeDecorations;