"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GcpCredentialsFormAgentless = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _compare = _interopRequireDefault(require("semver/functions/compare"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _i18nReact = require("@kbn/i18n-react");
var _get_template_url_package_info = require("../../../common/utils/get_template_url_package_info");
var _constants = require("../../../../common/constants");
var _gcp_credential_form = require("./gcp_credential_form");
var _utils = require("../utils");
var _aws_credentials_form = require("../aws_credentials_form/aws_credentials_form");
var _constants2 = require("../../../common/navigation/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GoogleCloudShellCredentialsGuide = props => {
  const GOOGLE_CLOUD_SHELL_EXTERNAL_DOC_URL = 'https://cloud.google.com/shell/docs';
  const Link = ({
    children,
    url
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: url,
    target: "_blank",
    rel: "noopener nofollow noreferrer",
    "data-test-subj": "externalLink"
  }, children);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.googleCloudShellCredentials.guide.description",
    defaultMessage: "The Google Cloud Shell Command below will generate a Service Account Credentials JSON key to set up access for assessing your GCP environment's security posture. Learn more about {learnMore}.",
    values: {
      learnMore: /*#__PURE__*/_react.default.createElement(Link, {
        url: GOOGLE_CLOUD_SHELL_EXTERNAL_DOC_URL
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.googleCloudShellCredentials.guide.learnMoreLinkText",
        defaultMessage: "Google Cloud Shell"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("ol", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.googleCloudShellCredentials.guide.steps.launch",
    defaultMessage: "Log into your {googleCloudConsole}",
    values: {
      googleCloudConsole: /*#__PURE__*/_react.default.createElement("strong", null, "Google Cloud Console")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, props !== null && props !== void 0 && props.isOrganization ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.googleCloudShellCredentials.guide.steps.copyWithOrgId",
    defaultMessage: "Replace <PROJECT_ID> and <ORG_ID_VALUE> in the following command with your project ID and organization ID then copy the command",
    ignoreTag: true
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.googleCloudShellCredentials.guide.steps.copyWithProjectId",
    defaultMessage: "Replace <PROJECT_ID> in the following command with your project ID then copy the command",
    ignoreTag: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    isCopyable: true,
    contentEditable: "true"
  }, props.commandText))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.googleCloudShellCredentials.guide.steps.cloudShellButton",
    defaultMessage: "Click the {cloudShellButton} button below and login into your account",
    values: {
      cloudShellButton: /*#__PURE__*/_react.default.createElement("strong", null, "Launch Google Cloud Shell")
    },
    ignoreTag: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.googleCloudShellCredentials.guide.steps.confirmation",
    defaultMessage: "Check {trustRepo} and click {confirmButton}",
    values: {
      confirmButton: /*#__PURE__*/_react.default.createElement("strong", null, "Confirm"),
      trustRepo: /*#__PURE__*/_react.default.createElement("em", null, "Trust Repo")
    },
    ignoreTag: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.googleCloudShellCredentials.guide.steps.runCloudShellScript",
    defaultMessage: "Paste and run command in the {googleCloudShell} terminal",
    values: {
      googleCloudShell: /*#__PURE__*/_react.default.createElement("strong", null, "Google Cloud Shell")
    },
    ignoreTag: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.googleCloudShellCredentials.guide.steps.copyJsonServiceKey",
    defaultMessage: "Run {catCommand} to view the service account key. Copy and paste Credentials JSON below",
    values: {
      catCommand: /*#__PURE__*/_react.default.createElement("code", null, "cat KEY_FILE.json")
    },
    ignoreTag: true
  }))))));
};
const GcpCredentialsFormAgentless = ({
  input,
  newPolicy,
  updatePolicy,
  disabled,
  packageInfo,
  hasInvalidRequiredVars
}) => {
  var _input$streams, _input$streams$, _input$streams$$vars, _input$streams$$vars$, _getTemplateUrlFromPa;
  const accountType = (_input$streams = input.streams) === null || _input$streams === void 0 ? void 0 : (_input$streams$ = _input$streams[0]) === null || _input$streams$ === void 0 ? void 0 : (_input$streams$$vars = _input$streams$.vars) === null || _input$streams$$vars === void 0 ? void 0 : (_input$streams$$vars$ = _input$streams$$vars['gcp.account_type']) === null || _input$streams$$vars$ === void 0 ? void 0 : _input$streams$$vars$.value;
  const isOrganization = accountType === _constants.ORGANIZATION_ACCOUNT;
  const organizationFields = ['gcp.organization_id', 'gcp.credentials.json'];
  const singleAccountFields = ['gcp.project_id', 'gcp.credentials.json'];
  const isValidSemantic = (0, _valid.default)(packageInfo.version);
  const showCloudCredentialsButton = isValidSemantic ? (0, _compare.default)(packageInfo.version, _constants.CLOUD_CREDENTIALS_PACKAGE_VERSION) >= 0 : false;

  /*
    For Agentless only JSON credentials type is supported.
    Also in case of organisation setup, project_id is not required in contrast to Agent-based.
   */
  const fields = (0, _gcp_credential_form.getInputVarsFields)(input, _gcp_credential_form.gcpField.fields).filter(field => {
    if (isOrganization) {
      return organizationFields.includes(field.id);
    } else {
      return singleAccountFields.includes(field.id);
    }
  });
  const cloudShellUrl = (_getTemplateUrlFromPa = (0, _get_template_url_package_info.getTemplateUrlFromPackageInfo)(packageInfo, input.policy_template, _get_template_url_package_info.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS.CLOUD_SHELL_URL)) === null || _getTemplateUrlFromPa === void 0 ? void 0 : _getTemplateUrlFromPa.replace(_constants.TEMPLATE_URL_ACCOUNT_TYPE_ENV_VAR, accountType);
  const commandText = `gcloud config set project ${isOrganization ? `<PROJECT_ID> && ORG_ID=<ORG_ID_VALUE>` : `<PROJECT_ID>`} ./deploy_service_account.sh`;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_gcp_credential_form.GCPSetupInfoContent, {
    isAgentless: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !showCloudCredentialsButton && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.cspIntegration.gcpCloudCredentials.cloudFormationSupportedMessage",
    defaultMessage: "Launch Cloud Shell for automated credentials not supported in current integration version. Please upgrade to the latest version to enable Launch Cloud Shell for automated credentials."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), showCloudCredentialsButton && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "cloudShellAccordianInstructions",
    "data-test-subj": "launchGoogleCloudShellAccordianInstructions",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, null, "Steps to Generate GCP Account Credentials"),
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(GoogleCloudShellCredentialsGuide, {
    isOrganization: isOrganization,
    commandText: commandText
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "launchGoogleCloudShellAgentlessButton",
    target: "_blank",
    iconSide: "left",
    iconType: "launch",
    href: cloudShellUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.agentlessForm.googleCloudShell.cloudCredentials.button",
    defaultMessage: "Launch Google Cloud Shell"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_gcp_credential_form.GcpInputVarFields, {
    disabled: disabled,
    fields: fields,
    onChange: (key, value) => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      [key]: {
        value
      }
    })),
    isOrganization: isOrganization,
    packageInfo: packageInfo,
    hasInvalidRequiredVars: hasInvalidRequiredVars
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.ReadDocumentation, {
    url: _constants2.cspIntegrationDocsNavigation.cspm.gcpGetStartedPath
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.GcpCredentialsFormAgentless = GcpCredentialsFormAgentless;