"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTextAttributes = getTextAttributes;
exports.getViewBox = void 0;
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMinX = (shapeType, viewBox, offset = 0) => {
  let {
    minX
  } = viewBox;
  if (shapeType !== _types.Progress.HORIZONTAL_BAR) {
    minX -= offset / 2;
  }
  return minX;
};
const getMinY = (shapeType, viewBox, offset = 0, labelWidth, labelHeight = 0) => {
  let {
    minY
  } = viewBox;
  if (shapeType === _types.Progress.SEMICIRCLE) {
    minY -= offset / 2;
  }
  if (shapeType !== _types.Progress.SEMICIRCLE && shapeType !== _types.Progress.VERTICAL_BAR) {
    minY -= offset / 2;
  }
  if (shapeType === _types.Progress.VERTICAL_BAR || shapeType === _types.Progress.VERTICAL_PILL) {
    minY -= labelHeight;
  }
  return minY;
};
const getWidth = (shapeType, viewBox, offset = 0, labelWidth = 0) => {
  let {
    width
  } = viewBox;
  if (shapeType !== _types.Progress.HORIZONTAL_BAR) {
    width += offset;
  }
  if (shapeType === _types.Progress.HORIZONTAL_BAR || shapeType === _types.Progress.HORIZONTAL_PILL) {
    width += labelWidth;
  }
  return width;
};
const getHeight = (shapeType, viewBox, offset = 0, labelWidth = 0, labelHeight = 0) => {
  let {
    height
  } = viewBox;
  if (shapeType === _types.Progress.SEMICIRCLE) {
    height += offset / 2;
  }
  if (shapeType !== _types.Progress.SEMICIRCLE && shapeType !== _types.Progress.VERTICAL_BAR) {
    height += offset;
  }
  if (shapeType === _types.Progress.VERTICAL_BAR || shapeType === _types.Progress.VERTICAL_PILL) {
    height += labelHeight;
  }
  return height;
};
const updateMinxAndWidthIfNecessary = (shapeType, labelWidth, minX, width) => {
  if ((shapeType === _types.Progress.VERTICAL_BAR || shapeType === _types.Progress.VERTICAL_PILL) && labelWidth > width) {
    minX = -labelWidth / 2;
    width = labelWidth;
  }
  return [minX, width];
};
const getViewBox = function (shapeType, viewBox, offset = 0, labelWidth = 0, labelHeight = 0) {
  const args = [shapeType, viewBox, offset, labelWidth, labelHeight];
  const minX = getMinX(...args);
  const minY = getMinY(...args);
  const width = getWidth(...args);
  const height = getHeight(...args);
  const [updatedMinX, updatedWidth] = updateMinxAndWidthIfNecessary(shapeType, labelWidth, minX, width);
  return {
    minX: updatedMinX,
    minY,
    width: updatedWidth,
    height
  };
};
exports.getViewBox = getViewBox;
function getTextAttributes(shapeType, textAttributes, offset = 0, label = '') {
  if (!label) {
    return textAttributes;
  }
  let {
    x,
    y,
    textContent
  } = textAttributes;
  textContent = label ? label.toString() : '';
  if (shapeType === _types.Progress.HORIZONTAL_PILL) {
    x = parseInt(String(x), 10) + offset / 2;
  }
  if (shapeType === _types.Progress.VERTICAL_PILL) {
    y = parseInt(String(y), 10) - offset / 2;
  }
  if (shapeType === _types.Progress.HORIZONTAL_BAR || shapeType === _types.Progress.HORIZONTAL_PILL) {
    x = parseInt(String(x), 10);
  }
  return {
    x,
    y,
    textContent
  };
}