"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockApmApiCallResponse = exports.getCallApmApiSpy = void 0;
var _lodash = require("lodash");
var _create_call_apm_api = require("./create_call_apm_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const spyObj = {
  createCallApmApi: _create_call_apm_api.createCallApmApi,
  callApmApi: _create_call_apm_api.callApmApi
};
const getCallApmApiSpy = () => jest.spyOn(spyObj, 'callApmApi');
exports.getCallApmApiSpy = getCallApmApiSpy;
const getSpy = (0, _lodash.once)(() => {
  const spy = getCallApmApiSpy();
  const cache = {};
  const response = (endpoint, fn) => {
    cache[endpoint] = fn;
  };
  spy.mockImplementation((endpoint, params) => {
    const fn = cache[endpoint];
    if (fn) {
      return Promise.resolve(fn(params));
    }
    throw new Error('No cached response defined for ' + endpoint);
  });
  return {
    response
  };
});
const mockApmApiCallResponse = (...args) => {
  getSpy().response(...args);
};
exports.mockApmApiCallResponse = mockApmApiCallResponse;