"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAdditionalConfigHash = createAdditionalConfigHash;
exports.createDocumentStatsHash = createDocumentStatsHash;
var _mlStringHash = require("@kbn/ml-string-hash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a hash from the document stats to determine if the document stats have changed.
 */
function createDocumentStatsHash(documentStats) {
  var _documentStats$docume, _documentStats$docume2, _documentStats$docume3, _documentStats$docume4;
  const lastTimeStampMs = (_documentStats$docume = documentStats.documentCountStats) === null || _documentStats$docume === void 0 ? void 0 : _documentStats$docume.lastDocTimeStampMs;
  const totalCount = (_documentStats$docume2 = documentStats.documentCountStats) === null || _documentStats$docume2 === void 0 ? void 0 : _documentStats$docume2.totalCount;
  const times = Object.keys((_documentStats$docume3 = (_documentStats$docume4 = documentStats.documentCountStats) === null || _documentStats$docume4 === void 0 ? void 0 : _documentStats$docume4.buckets) !== null && _documentStats$docume3 !== void 0 ? _documentStats$docume3 : {});
  const firstBucketTimeStamp = times.length ? times[0] : undefined;
  const lastBucketTimeStamp = times.length ? times[times.length - 1] : undefined;
  return (0, _mlStringHash.stringHash)(`${lastTimeStampMs}${totalCount}${firstBucketTimeStamp}${lastBucketTimeStamp}`);
}
function createAdditionalConfigHash(additionalStrings = []) {
  return (0, _mlStringHash.stringHash)(`${additionalStrings.join('')}`);
}