/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.synonyms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SynonymRule
implements Writeable,
ToXContentObject {
    public static final ParseField SYNONYMS_FIELD = new ParseField("synonyms", new String[0]);
    public static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ConstructingObjectParser<SynonymRule, Void> PARSER = new ConstructingObjectParser("synonym_rule", args -> {
        String id = (String)args[0];
        String synonyms = (String)args[1];
        return new SynonymRule(id, synonyms);
    });
    private final String synonyms;
    private final String id;

    public SynonymRule(@Nullable String id, String synonyms) {
        this.id = Objects.requireNonNullElse(id, UUIDs.base64UUID());
        this.synonyms = synonyms;
    }

    public SynonymRule(StreamInput in) throws IOException {
        this.id = in.readOptionalString();
        this.synonyms = in.readString();
    }

    public static SynonymRule fromXContent(XContentParser parser) {
        return (SynonymRule)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.id != null) {
            builder.field(ID_FIELD.getPreferredName(), this.id);
        }
        builder.field(SYNONYMS_FIELD.getPreferredName(), this.synonyms);
        builder.endObject();
        return builder;
    }

    public String synonyms() {
        return this.synonyms;
    }

    public String id() {
        return this.id;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.id);
        out.writeString(this.synonyms);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynonymRule that = (SynonymRule)o;
        return Objects.equals(this.synonyms, that.synonyms) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.synonyms, this.id);
    }

    public String validate() {
        if (this.synonyms.length() == 0) {
            return "[synonyms] field can't be empty";
        }
        String[] sides = SynonymRule.split(this.synonyms, "=>");
        if (sides.length > 1) {
            String[] outputs;
            String[] inputs;
            if (sides.length != 2) {
                return "More than one explicit mapping specified in the same synonyms rule: [" + this.synonyms + "]";
            }
            for (String input : inputs = SynonymRule.split(sides[0], ",")) {
                if (input.trim().length() != 0) continue;
                return "Incorrect syntax for [synonyms]: [" + this.synonyms + "]";
            }
            for (String output : outputs = SynonymRule.split(sides[1], ",")) {
                if (output.trim().length() != 0) continue;
                return "Incorrect syntax for [synonyms]: [" + this.synonyms + "]";
            }
        } else {
            String[] inputs;
            for (String input : inputs = SynonymRule.split(this.synonyms, ",")) {
                if (input.trim().length() != 0) continue;
                return "Incorrect syntax for [synonyms]: [" + this.synonyms + "]";
            }
        }
        return null;
    }

    private static String[] split(String s, String separator) {
        ArrayList<String> list = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int end = s.length();
        while (pos < end) {
            char ch;
            if (s.startsWith(separator, pos)) {
                if (sb.length() > 0) {
                    list.add(sb.toString());
                    sb = new StringBuilder();
                }
                pos += separator.length();
                continue;
            }
            if ((ch = s.charAt(pos++)) == '\\') {
                sb.append(ch);
                if (pos >= end) break;
                ch = s.charAt(pos++);
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    static {
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SYNONYMS_FIELD);
    }
}

