/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public final class SourceFilter {
    private Function<Map<String, Object>, Map<String, Object>> mapFilter = null;
    private Function<Source, Source> bytesFilter = null;
    private final boolean canFilterBytes;
    private final boolean empty;
    private final String[] includes;
    private final String[] excludes;
    private CharacterRunAutomaton includeAut;
    private CharacterRunAutomaton excludeAut;

    public SourceFilter(String[] includes, String[] excludes) {
        this.includes = includes == null ? Strings.EMPTY_ARRAY : includes;
        this.excludes = excludes == null ? Strings.EMPTY_ARRAY : excludes;
        this.canFilterBytes = CollectionUtils.isEmpty(excludes) || Arrays.stream(excludes).noneMatch(field -> field.contains("*"));
        this.empty = CollectionUtils.isEmpty(this.includes) && CollectionUtils.isEmpty(this.excludes);
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public boolean isPathFiltered(String fullPath, boolean isObject) {
        boolean included;
        int state;
        if (this.includes != null) {
            if (this.includeAut == null) {
                this.includeAut = XContentMapValues.compileAutomaton(this.includes, new CharacterRunAutomaton(Automata.makeAnyString()));
            }
            included = (state = SourceFilter.step(this.includeAut, fullPath, 0)) != -1 && (isObject || this.includeAut.isAccept(state));
        } else {
            included = true;
        }
        if (this.excludes != null) {
            if (this.excludeAut == null) {
                this.excludeAut = XContentMapValues.compileAutomaton(this.excludes, new CharacterRunAutomaton(Automata.makeEmpty()));
            }
            if ((state = SourceFilter.step(this.excludeAut, fullPath, 0)) != -1 && this.excludeAut.isAccept(state)) {
                return true;
            }
        }
        return !included;
    }

    private static int step(CharacterRunAutomaton automaton, String key, int state) {
        for (int i = 0; state != -1 && i < key.length(); ++i) {
            state = automaton.step(state, (int)key.charAt(i));
        }
        return state;
    }

    public Source filterMap(Source in) {
        if (this.empty) {
            return in;
        }
        if (this.mapFilter == null) {
            this.mapFilter = XContentMapValues.filter(this.includes, this.excludes);
        }
        return Source.fromMap(this.mapFilter.apply(in.source()), in.sourceContentType());
    }

    public Source filterBytes(Source in) {
        if (this.empty) {
            return in;
        }
        if (this.bytesFilter == null) {
            this.bytesFilter = this.buildBytesFilter();
        }
        return this.bytesFilter.apply(in);
    }

    private Function<Source, Source> buildBytesFilter() {
        if (!this.canFilterBytes) {
            return this::filterMap;
        }
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withFiltering(null, Set.copyOf(Arrays.asList(this.includes)), Set.copyOf(Arrays.asList(this.excludes)), true);
        return in -> {
            try {
                BytesStreamOutput streamOutput = new BytesStreamOutput(1024);
                XContent xContent = in.sourceContentType().xContent();
                XContentBuilder builder = new XContentBuilder(xContent, (OutputStream)streamOutput);
                try (XContentParser parser = XContentHelper.createParserNotCompressed(parserConfig, in.internalSourceRef(), xContent.type());){
                    if (parser.currentToken() == null && parser.nextToken() == null) {
                        Source source2 = Source.empty(in.sourceContentType());
                        return source2;
                    }
                    builder.copyCurrentStructure(parser);
                    Source source = Source.fromBytes(BytesReference.bytes(builder));
                    return source;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public boolean excludesAll() {
        return Arrays.asList(this.excludes).contains("*");
    }
}

