/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.SumAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

class AvgAggregator
extends SumAggregator {
    LongArray counts;

    AvgAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, valuesSourceConfig, context, parent, metadata);
        this.counts = context.bigArrays().newLongArray(1L, true);
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final SortedNumericDoubleValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    AvgAggregator.this.maybeGrow(bucket);
                    AvgAggregator.this.counts.increment(bucket, SumAggregator.sumSortedDoubles(bucket, values, AvgAggregator.this.sums, AvgAggregator.this.compensations));
                }
            }
        };
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final NumericDoubleValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, (Object)values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    AvgAggregator.this.maybeGrow(bucket);
                    SumAggregator.computeSum(bucket, values.doubleValue(), AvgAggregator.this.sums, AvgAggregator.this.compensations);
                    AvgAggregator.this.counts.increment(bucket, 1L);
                }
            }
        };
    }

    @Override
    protected void doGrow(long bucket, BigArrays bigArrays) {
        super.doGrow(bucket, bigArrays);
        this.counts = bigArrays.grow(this.counts, bucket + 1L);
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.sums.size()) {
            return Double.NaN;
        }
        return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalAvg(this.name, this.sums.get(bucket), this.counts.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalAvg.empty(this.name, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        super.doClose();
        Releasables.close((Releasable)this.counts);
    }
}

