/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.RepositoryStats;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.threadpool.ThreadPool;

public interface Repository
extends LifecycleComponent {
    @Nullable
    public ProjectId getProjectId();

    public RepositoryMetadata getMetadata();

    public void getSnapshotInfo(Collection<SnapshotId> var1, boolean var2, BooleanSupplier var3, CheckedConsumer<SnapshotInfo, Exception> var4, ActionListener<Void> var5);

    default public void getSnapshotInfo(SnapshotId snapshotId, final ActionListener<SnapshotInfo> listener) {
        this.getSnapshotInfo(List.of(snapshotId), true, () -> false, (CheckedConsumer<SnapshotInfo, Exception>)((CheckedConsumer)snapshotInfo -> {
            if (!2.$assertionsDisabled && !Repository.assertSnapshotMetaThread()) {
                throw new AssertionError();
            }
            listener.onResponse((SnapshotInfo)snapshotInfo);
        }), new ActionListener<Void>(this){

            @Override
            public void onResponse(Void o) {
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public Metadata getSnapshotGlobalMetadata(SnapshotId var1);

    public IndexMetadata getSnapshotIndexMetaData(RepositoryData var1, SnapshotId var2, IndexId var3) throws IOException;

    public void getRepositoryData(Executor var1, ActionListener<RepositoryData> var2);

    public void finalizeSnapshot(FinalizeSnapshotContext var1);

    public void deleteSnapshots(Collection<SnapshotId> var1, long var2, IndexVersion var4, ActionListener<RepositoryData> var5, Runnable var6);

    public long getSnapshotThrottleTimeInNanos();

    public long getRestoreThrottleTimeInNanos();

    default public RepositoryStats stats() {
        return RepositoryStats.EMPTY_STATS;
    }

    public String startVerification();

    public void endVerification(String var1);

    public void verify(String var1, DiscoveryNode var2);

    public boolean isReadOnly();

    public void snapshotShard(SnapshotShardContext var1);

    public void restoreShard(Store var1, SnapshotId var2, IndexId var3, ShardId var4, RecoveryState var5, ActionListener<Void> var6);

    public IndexShardSnapshotStatus.Copy getShardSnapshotStatus(SnapshotId var1, IndexId var2, ShardId var3);

    default public boolean canUpdateInPlace(Settings updatedSettings, Set<String> ignoredSettings) {
        return this.getMetadata().settings().equals(updatedSettings);
    }

    public void updateState(ClusterState var1);

    public void cloneShardSnapshot(SnapshotId var1, SnapshotId var2, RepositoryShardId var3, @Nullable ShardGeneration var4, ActionListener<ShardSnapshotResult> var5);

    public void awaitIdle();

    default public Set<String> getUsageFeatures() {
        return Set.of();
    }

    public static boolean assertSnapshotMetaThread() {
        return ThreadPool.assertCurrentThreadPool("snapshot_meta");
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface Factory {
        public Repository create(@Nullable ProjectId var1, RepositoryMetadata var2) throws Exception;

        default public Repository create(@Nullable ProjectId projectId, RepositoryMetadata metadata, Function<String, Factory> typeLookup) throws Exception {
            return this.create(projectId, metadata);
        }
    }
}

