/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.BitSet;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.VocabularyImpl;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.parser.AstBuilder;
import org.elasticsearch.xpack.esql.parser.DelegatingTokenSource;
import org.elasticsearch.xpack.esql.parser.EsqlBaseLexer;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParserBaseListener;
import org.elasticsearch.xpack.esql.parser.EsqlConfig;
import org.elasticsearch.xpack.esql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.esql.parser.LogicalPlanBuilder;
import org.elasticsearch.xpack.esql.parser.ParserUtils;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.QueryParams;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.telemetry.PlanTelemetry;

public class EsqlParser {
    private static final Logger log = LogManager.getLogger(EsqlParser.class);
    public static final int MAX_LENGTH = 1000000;
    private EsqlConfig config = new EsqlConfig();
    private static final BaseErrorListener ERROR_LISTENER;

    private static void replaceSymbolWithLiteral(Map<String, String> symbolReplacements, String[] literalNames, String[] symbolicNames) {
        int replacements = symbolReplacements.size();
        for (int i = 0; i < symbolicNames.length && replacements > 0; ++i) {
            String replacement;
            String symName = symbolicNames[i];
            if (symName == null || (replacement = symbolReplacements.get(symName)) == null || literalNames[i] != null) continue;
            literalNames[i] = "'" + replacement + "'";
            --replacements;
        }
    }

    public EsqlConfig config() {
        return this.config;
    }

    public void setEsqlConfig(EsqlConfig config) {
        this.config = config;
    }

    public LogicalPlan createStatement(String query, Configuration configuration) {
        return this.createStatement(query, new QueryParams(), configuration);
    }

    public LogicalPlan createStatement(String query, QueryParams params, Configuration configuration) {
        return this.createStatement(query, params, new PlanTelemetry(new EsqlFunctionRegistry()), configuration);
    }

    public LogicalPlan createStatement(String query, QueryParams params, PlanTelemetry metrics, Configuration configuration) {
        if (log.isDebugEnabled()) {
            log.debug("Parsing as statement: {}", new Object[]{query});
        }
        return this.invokeParser(query, params, metrics, EsqlBaseParser::singleStatement, LogicalPlanBuilder::plan, configuration);
    }

    private <T> T invokeParser(String query, QueryParams params, PlanTelemetry metrics, Function<EsqlBaseParser, ParserRuleContext> parseFunction, BiFunction<AstBuilder, ParserRuleContext, T> result, Configuration configuration) {
        if (query.length() > 1000000) {
            throw new ParsingException("ESQL statement is too large [{} characters > {}]", query.length(), 1000000);
        }
        try {
            EsqlBaseLexer lexer = new EsqlBaseLexer((CharStream)CharStreams.fromString((String)query));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            lexer.setEsqlConfig(this.config);
            ParametrizedTokenSource tokenSource = new ParametrizedTokenSource((TokenSource)lexer, params);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)tokenSource);
            EsqlBaseParser parser = new EsqlBaseParser((TokenStream)tokenStream);
            parser.addParseListener(new PostProcessor(this));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            parser.setEsqlConfig(this.config);
            ParserRuleContext tree = parseFunction.apply(parser);
            if (log.isTraceEnabled()) {
                log.trace("Parse tree: {}", new Object[]{tree.toStringTree()});
            }
            return result.apply(new AstBuilder(new ExpressionBuilder.ParsingContext(params, metrics)), tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException("ESQL statement is too large, causing stack overflow when generating the parsing tree: [{}]", query);
        }
        catch (EmptyStackException ese) {
            throw new ParsingException("Invalid query [{}]", query);
        }
    }

    static {
        Map<String, String> symbolReplacements = Map.of("LP", "(", "OPENING_BRACKET", "[");
        VocabularyImpl parserVocab = (VocabularyImpl)EsqlBaseParser.VOCABULARY;
        EsqlParser.replaceSymbolWithLiteral(symbolReplacements, parserVocab.getLiteralNames(), parserVocab.getSymbolicNames());
        VocabularyImpl lexerVocab = (VocabularyImpl)EsqlBaseLexer.VOCABULARY;
        EsqlParser.replaceSymbolWithLiteral(symbolReplacements, lexerVocab.getLiteralNames(), lexerVocab.getSymbolicNames());
        ERROR_LISTENER = new BaseErrorListener(){
            private final Pattern REPLACE_DEV = Pattern.compile(",*\\s*DEV_\\w+\\s*");

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
                EsqlBaseParser parser;
                if (recognizer instanceof EsqlBaseParser && !(parser = (EsqlBaseParser)recognizer).isDevVersion()) {
                    Matcher m = this.REPLACE_DEV.matcher(message);
                    message = m.replaceAll("");
                }
                throw new ParsingException(message, (Exception)((Object)e), line, charPositionInLine);
            }
        };
    }

    private static class ParametrizedTokenSource
    extends DelegatingTokenSource {
        private static String message = "Inconsistent parameter declaration, use one of positional, named or anonymous params but not a combination of ";
        private QueryParams params;
        private BitSet paramTypes = new BitSet(3);
        private int param = 1;

        ParametrizedTokenSource(TokenSource delegate, QueryParams params) {
            super(delegate);
            this.params = params;
        }

        @Override
        public Token nextToken() {
            String nameOrPosition;
            Token token = this.delegate.nextToken();
            if (token.getType() == 76 || token.getType() == 94) {
                this.checkAnonymousParam(token);
                if (this.param > this.params.size()) {
                    throw new ParsingException(ParserUtils.source(token), "Not enough actual parameters {}", this.params.size());
                }
                this.params.addTokenParam(token, this.params.get(this.param));
                ++this.param;
            }
            if (!(nameOrPosition = ParserUtils.nameOrPosition(token)).isBlank()) {
                if (StringUtils.isInteger((String)nameOrPosition)) {
                    this.checkPositionalParam(token);
                } else {
                    this.checkNamedParam(token);
                }
            }
            return token;
        }

        private void checkAnonymousParam(Token token) {
            this.paramTypes.set(0);
            if (this.paramTypes.cardinality() > 1) {
                throw new ParsingException(ParserUtils.source(token), message + "anonymous and " + (this.paramTypes.get(1) ? "named" : "positional"), new Object[0]);
            }
        }

        private void checkNamedParam(Token token) {
            this.paramTypes.set(1);
            if (this.paramTypes.cardinality() > 1) {
                throw new ParsingException(ParserUtils.source(token), message + "named and " + (this.paramTypes.get(0) ? "anonymous" : "positional"), new Object[0]);
            }
        }

        private void checkPositionalParam(Token token) {
            this.paramTypes.set(2);
            if (this.paramTypes.cardinality() > 1) {
                throw new ParsingException(ParserUtils.source(token), message + "positional and " + (this.paramTypes.get(0) ? "anonymous" : "named"), new Object[0]);
            }
        }
    }

    private class PostProcessor
    extends EsqlBaseParserBaseListener {
        private PostProcessor(EsqlParser esqlParser) {
        }

        @Override
        public void exitFunctionExpression(EsqlBaseParser.FunctionExpressionContext ctx) {
            EsqlBaseParser.FunctionNameContext identifier = ctx.functionName();
            if (identifier.getText().equalsIgnoreCase("is_null")) {
                throw new ParsingException(ParserUtils.source(ctx), "is_null function is not supported anymore, please use 'is null'/'is not null' predicates instead", new Object[0]);
            }
        }
    }
}

