/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.ServiceDisruptionScheme;
import org.junit.Assert;

public abstract class SingleNodeDisruption
implements ServiceDisruptionScheme {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected volatile String disruptedNode;
    protected volatile InternalTestCluster cluster;
    protected final Random random;

    public SingleNodeDisruption(Random random) {
        this.random = new Random(random.nextLong());
    }

    @Override
    public void applyToCluster(InternalTestCluster testCluster) {
        this.cluster = testCluster;
        if (this.disruptedNode == null) {
            String[] nodes = testCluster.getNodeNames();
            this.disruptedNode = nodes[this.random.nextInt(nodes.length)];
        }
    }

    @Override
    public void removeFromCluster(InternalTestCluster testCluster) {
        if (this.disruptedNode != null) {
            this.removeFromNode(this.disruptedNode, testCluster);
        }
    }

    @Override
    public synchronized void applyToNode(String node, InternalTestCluster testCluster) {
    }

    @Override
    public synchronized void removeFromNode(String node, InternalTestCluster testCluster) {
        if (this.disruptedNode == null) {
            return;
        }
        if (!node.equals(this.disruptedNode)) {
            return;
        }
        this.stopDisrupting();
        this.disruptedNode = null;
    }

    @Override
    public synchronized void testClusterClosed() {
        this.disruptedNode = null;
    }

    protected void ensureNodeCount(InternalTestCluster testCluster) {
        Assert.assertFalse((String)"cluster failed to form after disruption was healed", (boolean)((ClusterHealthResponse)testCluster.client().admin().cluster().prepareHealth(ESTestCase.TEST_REQUEST_TIMEOUT, new String[0]).setWaitForNodes(String.valueOf(testCluster.size())).setWaitForNoRelocatingShards(true).get()).isTimedOut());
    }
}

