/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public final class RandomCreateIndexGenerator {
    private RandomCreateIndexGenerator() {
    }

    public static CreateIndexRequest randomCreateIndexRequest() {
        String index = ESTestCase.randomAlphaOfLength(5);
        CreateIndexRequest request = new CreateIndexRequest(index);
        RandomCreateIndexGenerator.randomAliases(request);
        if (ESTestCase.randomBoolean()) {
            request.mapping(RandomCreateIndexGenerator.randomMapping("_doc"));
        }
        if (ESTestCase.randomBoolean()) {
            request.settings(RandomCreateIndexGenerator.randomIndexSettings());
        }
        return request;
    }

    public static Settings randomIndexSettings() {
        Settings.Builder builder = Settings.builder();
        if (ESTestCase.randomBoolean()) {
            int numberOfShards = ESTestCase.randomIntBetween(1, 10);
            builder.put("index.number_of_shards", numberOfShards);
        }
        if (ESTestCase.randomBoolean()) {
            int numberOfReplicas = ESTestCase.randomIntBetween(1, 10);
            builder.put("index.number_of_replicas", numberOfReplicas);
        }
        return builder.build();
    }

    public static XContentBuilder randomMapping(String type) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)ESTestCase.randomFrom(XContentType.values()));
            builder.startObject().startObject(type);
            RandomCreateIndexGenerator.randomMappingFields(builder, true);
            builder.endObject().endObject();
            return builder;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void randomMappingFields(XContentBuilder builder, boolean allowObjectField) {
        try {
            builder.startObject("properties");
            int fieldsNo = ESTestCase.randomIntBetween(0, 5);
            for (int i = 0; i < fieldsNo; ++i) {
                builder.startObject(ESTestCase.randomAlphaOfLength(5));
                if (allowObjectField && ESTestCase.randomBoolean()) {
                    RandomCreateIndexGenerator.randomMappingFields(builder, false);
                } else {
                    builder.field("type", "text");
                }
                builder.endObject();
            }
            builder.endObject();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void randomAliases(CreateIndexRequest request) {
        int aliasesNo = ESTestCase.randomIntBetween(0, 2);
        for (int i = 0; i < aliasesNo; ++i) {
            request.alias(RandomCreateIndexGenerator.randomAlias());
        }
    }

    public static Alias randomAlias() {
        Alias alias = new Alias(ESTestCase.randomAlphaOfLength(5));
        if (ESTestCase.randomBoolean()) {
            if (ESTestCase.randomBoolean()) {
                alias.routing(ESTestCase.randomAlphaOfLength(5));
            } else {
                if (ESTestCase.randomBoolean()) {
                    alias.indexRouting(ESTestCase.randomAlphaOfLength(5));
                }
                if (ESTestCase.randomBoolean()) {
                    alias.searchRouting(ESTestCase.randomAlphaOfLength(5));
                }
            }
        }
        if (ESTestCase.randomBoolean()) {
            alias.filter("{\"term\":{\"year\":2016}}");
        }
        if (ESTestCase.randomBoolean()) {
            alias.writeIndex(Boolean.valueOf(ESTestCase.randomBoolean()));
        }
        return alias;
    }
}

