/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.fields.leaf;

import java.net.InetAddress;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.datageneration.FieldDataGenerator;
import org.elasticsearch.datageneration.datasource.DataSource;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.fields.leaf.Wrappers;

public class IpFieldDataGenerator
implements FieldDataGenerator {
    private final Supplier<Object> valueGenerator;
    private final Supplier<Object> valueGeneratorWithMalformed;

    public IpFieldDataGenerator(DataSource dataSource) {
        Supplier<InetAddress> ips = dataSource.get(new DataSourceRequest.IpGenerator()).generator();
        Supplier<String> formattedIps = () -> NetworkAddress.format((InetAddress)((InetAddress)ips.get()));
        this.valueGenerator = Wrappers.defaults(formattedIps::get, dataSource);
        Supplier<String> strings = dataSource.get(new DataSourceRequest.StringGenerator()).generator();
        this.valueGeneratorWithMalformed = Wrappers.defaultsWithMalformed(formattedIps::get, strings::get, dataSource);
    }

    @Override
    public Object generateValue(Map<String, Object> fieldMapping) {
        if (fieldMapping != null && ((Boolean)fieldMapping.getOrDefault("ignore_malformed", false)).booleanValue()) {
            return this.valueGeneratorWithMalformed.get();
        }
        return this.valueGenerator.get();
    }
}

