/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.datasource;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.test.ESTestCase;

public class DefaultWrappersHandler
implements DataSourceHandler {
    @Override
    public DataSourceResponse.NullWrapper handle(DataSourceRequest.NullWrapper ignored) {
        return new DataSourceResponse.NullWrapper(DefaultWrappersHandler.injectNulls());
    }

    @Override
    public DataSourceResponse.ArrayWrapper handle(DataSourceRequest.ArrayWrapper ignored) {
        return new DataSourceResponse.ArrayWrapper(DefaultWrappersHandler.wrapInArray());
    }

    @Override
    public DataSourceResponse.RepeatingWrapper handle(DataSourceRequest.RepeatingWrapper ignored) {
        return new DataSourceResponse.RepeatingWrapper(DefaultWrappersHandler.repeatValues());
    }

    @Override
    public DataSourceResponse.MalformedWrapper handle(DataSourceRequest.MalformedWrapper request) {
        return new DataSourceResponse.MalformedWrapper(DefaultWrappersHandler.injectMalformed(request.malformedValues()));
    }

    @Override
    public DataSourceResponse.TransformWrapper handle(DataSourceRequest.TransformWrapper request) {
        return new DataSourceResponse.TransformWrapper(DefaultWrappersHandler.transform(request.transformedProportion(), request.transformation()));
    }

    @Override
    public DataSourceResponse.TransformWeightedWrapper handle(DataSourceRequest.TransformWeightedWrapper<?> request) {
        return new DataSourceResponse.TransformWeightedWrapper(DefaultWrappersHandler.transformWeighted(request.transformations()));
    }

    private static Function<Supplier<Object>, Supplier<Object>> injectNulls() {
        return DefaultWrappersHandler.transform(0.05, ignored -> null);
    }

    private static Function<Supplier<Object>, Supplier<Object>> wrapInArray() {
        return values -> () -> DefaultWrappersHandler.lambda$wrapInArray$2((Supplier)values);
    }

    private static Function<Supplier<Object>, Supplier<Object>> repeatValues() {
        return values -> {
            HashSet previousValues = new HashSet();
            return () -> DefaultWrappersHandler.lambda$repeatValues$4(previousValues, (Supplier)values);
        };
    }

    private static Function<Supplier<Object>, Supplier<Object>> injectMalformed(Supplier<Object> malformedValues) {
        return DefaultWrappersHandler.transform(0.1, ignored -> malformedValues.get());
    }

    private static Function<Supplier<Object>, Supplier<Object>> transform(double transformedProportion, Function<Object, Object> transformation) {
        return values -> () -> DefaultWrappersHandler.lambda$transform$7(transformedProportion, transformation, (Supplier)values);
    }

    public static <T> Function<Supplier<Object>, Supplier<Object>> transformWeighted(List<Tuple<Double, Function<T, Object>>> transformations) {
        double totalWeight = transformations.stream().mapToDouble(Tuple::v1).sum();
        if (totalWeight != 1.0) {
            throw new IllegalArgumentException("Sum of weights must be equal to 1");
        }
        ArrayList<Tuple> lookup = new ArrayList<Tuple>();
        Double leftBound = 0.0;
        for (Tuple<Double, Function<T, Object>> tuple : transformations) {
            lookup.add(Tuple.tuple((Object)leftBound, (Object)(leftBound + (Double)tuple.v1())));
            leftBound = leftBound + (Double)tuple.v1();
        }
        return values -> {
            double roll = ESTestCase.randomDouble();
            for (int i = 0; i < lookup.size(); ++i) {
                Tuple bounds = (Tuple)lookup.get(i);
                if (!(roll >= (Double)bounds.v1()) || !(roll <= (Double)bounds.v2())) continue;
                Function transformation = (Function)((Tuple)transformations.get(i)).v2();
                return () -> DefaultWrappersHandler.lambda$transformWeighted$9(transformation, (Supplier)values);
            }
            assert (false) : "Should not get here if weights add up to 1";
            return null;
        };
    }

    private static /* synthetic */ Object lambda$transformWeighted$9(Function transformation, Supplier values) {
        return transformation.apply(values.get());
    }

    private static /* synthetic */ Object lambda$transform$7(double transformedProportion, Function transformation, Supplier values) {
        return ESTestCase.randomDouble() <= transformedProportion ? transformation.apply(values.get()) : values.get();
    }

    private static /* synthetic */ Object lambda$repeatValues$4(HashSet previousValues, Supplier values) {
        if (previousValues.size() > 0 && ESTestCase.randomBoolean()) {
            return ESTestCase.randomFrom(previousValues);
        }
        Object value = values.get();
        previousValues.add(value);
        return value;
    }

    private static /* synthetic */ Object lambda$wrapInArray$2(Supplier values) {
        if (ESTestCase.randomBoolean()) {
            int size = ESTestCase.randomIntBetween(0, 5);
            return IntStream.range(0, size).mapToObj(arg_0 -> DefaultWrappersHandler.lambda$wrapInArray$1((Supplier)values, arg_0)).toList();
        }
        return values.get();
    }

    private static /* synthetic */ Object lambda$wrapInArray$1(Supplier values, int i) {
        return values.get();
    }
}

