/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.junit.Assert;

public class CountingPageCacheRecycler
extends PageCacheRecycler {
    private int openPages = 0;

    public CountingPageCacheRecycler() {
        super(Settings.EMPTY);
    }

    public Recycler.V<byte[]> bytePage(boolean clear) {
        final Recycler.V page = super.bytePage(clear);
        ++this.openPages;
        return new Recycler.V<byte[]>(){
            boolean closed = false;

            public byte[] v() {
                return (byte[])page.v();
            }

            public boolean isRecycled() {
                return page.isRecycled();
            }

            public void close() {
                Assert.assertFalse((boolean)this.closed);
                this.closed = true;
                --CountingPageCacheRecycler.this.openPages;
                page.close();
            }
        };
    }

    public Recycler.V<Object[]> objectPage() {
        throw new AssertionError((Object)"unexpected call to objectPage()");
    }

    public void assertAllPagesReleased() {
        Assert.assertEquals((long)0L, (long)this.openPages);
    }
}

