/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class UpdateSettingsStep
extends AsyncActionStep {
    public static final String NAME = "update-settings";
    private final Settings settings;

    public UpdateSettingsStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, Settings settings) {
        super(key, nextStepKey, client);
        this.settings = settings;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ProjectState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        UpdateSettingsRequest updateSettingsRequest = ((UpdateSettingsRequest)new UpdateSettingsRequest(new String[]{indexMetadata.getIndex().getName()}).masterNodeTimeout(TimeValue.MAX_VALUE)).settings(this.settings);
        this.getClient(currentState.projectId()).admin().indices().updateSettings(updateSettingsRequest, listener.delegateFailureAndWrap((l, r) -> l.onResponse(null)));
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.settings);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateSettingsStep other = (UpdateSettingsStep)obj;
        return super.equals(obj) && Objects.equals(this.settings, other.settings);
    }
}

