/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.wildcard.mapper;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.LowercaseNormalizer;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.StringBinaryIndexFieldData;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.wildcard.WildcardDocValuesField;
import org.elasticsearch.xpack.wildcard.mapper.BinaryDvConfirmedQuery;

public class WildcardFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "wildcard";
    public static final short MAX_CLAUSES_IN_APPROXIMATION_QUERY = 10;
    private static final int WILDCARD_TERMS_EXPANSION_LIMIT = 16;
    public static final int NGRAM_SIZE = 3;
    static final NamedAnalyzer WILDCARD_ANALYZER_7_10 = new NamedAnalyzer("_wildcard_7_10", AnalyzerScope.GLOBAL, new Analyzer(){

        @Override
        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            NGramTokenizer tokenizer = new NGramTokenizer(3, 3);
            TokenFilter tok = new LowerCaseFilter(tokenizer);
            tok = new PunctuationFoldingFilter(tok);
            return new Analyzer.TokenStreamComponents(tokenizer::setReader, (TokenStream)tok);
        }
    });
    @Deprecated
    static final NamedAnalyzer WILDCARD_ANALYZER_7_9 = new NamedAnalyzer("_wildcard", AnalyzerScope.GLOBAL, new Analyzer(){

        @Override
        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            NGramTokenizer tokenizer = new NGramTokenizer(3, 3);
            LowerCaseFilter tok = new LowerCaseFilter(tokenizer);
            return new Analyzer.TokenStreamComponents(tokenizer::setReader, (TokenStream)tok);
        }
    });
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, IndexSettings.IGNORE_ABOVE_SETTING.get(c.getSettings()), c.indexVersionCreated()));
    public static final char TOKEN_START_OR_END_CHAR = '\u0000';
    public static final String TOKEN_START_STRING = Character.toString('\u0000');
    public static final String TOKEN_END_STRING = TOKEN_START_STRING + TOKEN_START_STRING;
    private static final FieldType NGRAM_FIELD_TYPE;
    private final String nullValue;
    private final IndexVersion indexVersionCreated;
    private final int ignoreAbove;
    private final int ignoreAboveDefault;
    private final boolean storeIgnored;
    private final String originalName;

    private static WildcardFieldMapper toType(FieldMapper in) {
        return (WildcardFieldMapper)in;
    }

    private WildcardFieldMapper(String simpleName, WildcardFieldType mappedFieldType, boolean storeIgnored, FieldMapper.BuilderParams builderParams, IndexVersion indexVersionCreated, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        this.nullValue = builder.nullValue.getValue();
        this.storeIgnored = storeIgnored;
        this.indexVersionCreated = indexVersionCreated;
        this.ignoreAbove = builder.ignoreAbove.getValue();
        this.ignoreAboveDefault = builder.ignoreAboveDefault;
        this.originalName = storeIgnored ? this.fullPath() + "._original" : null;
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), this.fieldType().analyzer);
    }

    int ignoreAbove() {
        return this.ignoreAbove;
    }

    @Override
    public WildcardFieldType fieldType() {
        return (WildcardFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        String value = parser.currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull();
        LuceneDocument parseDoc = context.doc();
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
        if (value != null) {
            if (value.length() <= this.ignoreAbove) {
                this.createFields(value, parseDoc, fields);
            } else {
                context.addIgnoredField(this.fullPath());
                if (this.storeIgnored) {
                    parseDoc.add(new StoredField(this.originalName(), new BytesRef(value)));
                }
            }
        }
        parseDoc.addAll(fields);
    }

    private String originalName() {
        return this.originalName;
    }

    void createFields(String value, LuceneDocument parseDoc, List<IndexableField> fields) {
        String ngramValue = WildcardFieldMapper.addLineEndChars(value);
        Field ngramField = new Field(this.fieldType().name(), ngramValue, (IndexableFieldType)NGRAM_FIELD_TYPE);
        fields.add(ngramField);
        BinaryFieldMapper.CustomBinaryDocValuesField dvField = (BinaryFieldMapper.CustomBinaryDocValuesField)parseDoc.getByKey(this.fieldType().name());
        if (dvField == null) {
            dvField = new BinaryFieldMapper.CustomBinaryDocValuesField(this.fieldType().name(), value.getBytes(StandardCharsets.UTF_8));
            parseDoc.addWithKey(this.fieldType().name(), dvField);
        } else {
            dvField.add(value.getBytes(StandardCharsets.UTF_8));
        }
    }

    static String addLineEndChars(String value) {
        return "\u0000" + value + "\u0000\u0000";
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.ignoreAboveDefault, this.indexVersionCreated).init(this);
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> {
            ArrayList<CompositeSyntheticFieldLoader.Layer> layers = new ArrayList<CompositeSyntheticFieldLoader.Layer>();
            layers.add(new WildcardSyntheticFieldLoader());
            if (this.ignoreAbove != Integer.MAX_VALUE) {
                layers.add(new CompositeSyntheticFieldLoader.StoredFieldLayer(this, this.originalName()){

                    @Override
                    protected void writeValue(Object value, XContentBuilder b) throws IOException {
                        BytesRef r = (BytesRef)value;
                        b.utf8Value(r.bytes, r.offset, r.length);
                    }
                });
            }
            return new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), layers);
        });
    }

    static {
        FieldType ft = new FieldType(Defaults.FIELD_TYPE);
        ft.setTokenized(true);
        NGRAM_FIELD_TYPE = WildcardFieldMapper.freezeAndDeduplicateFieldType(ft);
        assert (NGRAM_FIELD_TYPE.indexOptions() == IndexOptions.DOCS);
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Integer> ignoreAbove;
        final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> WildcardFieldMapper.toType((FieldMapper)m).nullValue, null).acceptsNull();
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final IndexVersion indexVersionCreated;
        final int ignoreAboveDefault;

        public Builder(String name, IndexVersion indexVersionCreated) {
            this(name, Integer.MAX_VALUE, indexVersionCreated);
        }

        private Builder(String name, int ignoreAboveDefault, IndexVersion indexVersionCreated) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
            this.ignoreAboveDefault = ignoreAboveDefault;
            this.ignoreAbove = FieldMapper.Parameter.intParam("ignore_above", true, m -> WildcardFieldMapper.toType((FieldMapper)m).ignoreAbove, ignoreAboveDefault).addValidator(v -> {
                if (v < 0) {
                    throw new IllegalArgumentException("[ignore_above] must be positive, got [" + v + "]");
                }
            });
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.ignoreAbove, this.nullValue, this.meta};
        }

        Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue(ignoreAbove);
            return this;
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        @Override
        public WildcardFieldMapper build(MapperBuilderContext context) {
            return new WildcardFieldMapper(this.leafName(), new WildcardFieldType(context.buildFullName(this.leafName()), this.indexVersionCreated, this.meta.get(), this), context.isSourceSynthetic(), this.builderParams(this, context), this.indexVersionCreated, this);
        }
    }

    public static final class WildcardFieldType
    extends MappedFieldType {
        static Analyzer lowercaseNormalizer = new LowercaseNormalizer();
        private final String nullValue;
        private final NamedAnalyzer analyzer;
        private final int ignoreAbove;

        private WildcardFieldType(String name, IndexVersion version, Map<String, String> meta, Builder builder) {
            super(name, true, false, true, Defaults.TEXT_SEARCH_INFO, meta);
            this.analyzer = version.onOrAfter(IndexVersions.V_7_10_0) ? WILDCARD_ANALYZER_7_10 : WILDCARD_ANALYZER_7_9;
            this.nullValue = builder.nullValue.getValue();
            this.ignoreAbove = builder.ignoreAbove.getValue();
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        @Override
        public Query normalizedWildcardQuery(String value, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            return this.wildcardQuery(value, method, false, context);
        }

        @Override
        public Query wildcardQuery(String wildcardPattern, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            Automaton automaton;
            BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
            Integer numClauses = this.getApproxWildCardQuery(wildcardPattern, rewritten);
            if (numClauses == null) {
                return new FieldExistsQuery(this.name());
            }
            Automaton automaton2 = automaton = caseInsensitive ? AutomatonQueries.toCaseInsensitiveWildcardAutomaton(new Term(this.name(), wildcardPattern)) : WildcardQuery.toAutomaton(new Term(this.name(), wildcardPattern), 10000);
            if (numClauses > 0) {
                BooleanQuery approxQuery = rewritten.build();
                return BinaryDvConfirmedQuery.fromAutomaton(approxQuery, this.name(), wildcardPattern, automaton);
            }
            return BinaryDvConfirmedQuery.fromAutomaton(new MatchAllDocsQuery(), this.name(), wildcardPattern, automaton);
        }

        private Integer getApproxWildCardQuery(String wildcardPattern, BooleanQuery.Builder rewritten) {
            LinkedHashSet<String> tokens = new LinkedHashSet<String>();
            boolean matchAll = this.breakIntoTokens(wildcardPattern, tokens);
            if (matchAll) {
                return null;
            }
            int clauseCount = 0;
            for (String string : tokens) {
                if (clauseCount >= 10) break;
                this.addClause(string, rewritten, BooleanClause.Occur.MUST);
                ++clauseCount;
            }
            return clauseCount;
        }

        private boolean breakIntoTokens(String wildcardPattern, Set<String> tokens) {
            int length;
            String ngramIndexPattern = WildcardFieldMapper.addLineEndChars(wildcardPattern);
            StringBuilder sequence = new StringBuilder();
            int numWildcardChars = 0;
            int numWildcardStrings = 0;
            block5: for (int i = 0; i < ngramIndexPattern.length(); i += length) {
                int c = ngramIndexPattern.codePointAt(i);
                length = Character.charCount(c);
                switch (c) {
                    case 42: {
                        if (sequence.length() > 0) {
                            this.getNgramTokens(tokens, sequence.toString());
                            sequence = new StringBuilder();
                        }
                        ++numWildcardStrings;
                        continue block5;
                    }
                    case 63: {
                        if (sequence.length() > 0) {
                            this.getNgramTokens(tokens, sequence.toString());
                            sequence = new StringBuilder();
                        }
                        ++numWildcardChars;
                        continue block5;
                    }
                    case 92: {
                        if (i + length < ngramIndexPattern.length()) {
                            int nextChar = ngramIndexPattern.codePointAt(i + length);
                            length += Character.charCount(nextChar);
                            sequence.append(Character.toChars(nextChar));
                            continue block5;
                        }
                        sequence.append(Character.toChars(c));
                        continue block5;
                    }
                    default: {
                        sequence.append(Character.toChars(c));
                    }
                }
            }
            if (sequence.length() > 0) {
                this.getNgramTokens(tokens, sequence.toString());
            }
            return tokens.isEmpty() && (numWildcardChars == 0 || numWildcardStrings > 0);
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            if (value.length() == 0) {
                return new MatchNoDocsQuery();
            }
            RegExp regExp = new RegExp(value, syntaxFlags, matchFlags);
            Automaton a = regExp.toAutomaton();
            if (Operations.isTotal(a = Operations.determinize(a, maxDeterminizedStates))) {
                return this.existsQuery(context);
            }
            RegExp ngramRegex = new RegExp(WildcardFieldMapper.addLineEndChars(value), syntaxFlags, matchFlags);
            Query approxBooleanQuery = WildcardFieldType.toApproximationQuery(ngramRegex);
            Query approxNgramQuery = this.rewriteBoolToNgramQuery(approxBooleanQuery);
            RegExp regex = new RegExp(value, syntaxFlags, matchFlags);
            Automaton automaton = Operations.determinize(regex.toAutomaton(), maxDeterminizedStates);
            return BinaryDvConfirmedQuery.fromAutomaton(approxNgramQuery, this.name(), value, automaton);
        }

        public static Query toApproximationQuery(RegExp r) throws IllegalArgumentException {
            Query result = null;
            switch (r.kind) {
                case REGEXP_CHAR_CLASS: {
                    result = WildcardFieldType.createCharacterClassQuery(r);
                    break;
                }
                case REGEXP_UNION: {
                    result = WildcardFieldType.createUnionQuery(r);
                    break;
                }
                case REGEXP_CONCATENATION: {
                    result = WildcardFieldType.createConcatenationQuery(r);
                    break;
                }
                case REGEXP_STRING: {
                    String normalizedString = WildcardFieldType.toLowerCase(r.s);
                    result = new TermQuery(new Term("", normalizedString));
                    break;
                }
                case REGEXP_CHAR: {
                    String cs = Character.toString(r.c);
                    String normalizedChar = WildcardFieldType.toLowerCase(cs);
                    result = new TermQuery(new Term("", normalizedChar));
                    break;
                }
                case REGEXP_REPEAT: {
                    result = new MatchAllDocsQuery();
                    break;
                }
                case REGEXP_REPEAT_MIN: 
                case REGEXP_REPEAT_MINMAX: {
                    if (r.min > 0) {
                        result = WildcardFieldType.toApproximationQuery(r.exp1);
                        if (!(result instanceof TermQuery)) break;
                        BooleanQuery.Builder wrapper = new BooleanQuery.Builder();
                        wrapper.add(result, BooleanClause.Occur.FILTER);
                        result = wrapper.build();
                        break;
                    }
                    result = new MatchAllDocsQuery();
                    break;
                }
                case REGEXP_ANYSTRING: {
                    result = new MatchAllDocsQuery();
                    break;
                }
                case REGEXP_OPTIONAL: 
                case REGEXP_INTERSECTION: 
                case REGEXP_COMPLEMENT: 
                case REGEXP_CHAR_RANGE: 
                case REGEXP_ANYCHAR: 
                case REGEXP_INTERVAL: 
                case REGEXP_EMPTY: 
                case REGEXP_AUTOMATON: {
                    result = new MatchAllDocsQuery();
                }
            }
            assert (result != null);
            return result;
        }

        private static Query createConcatenationQuery(RegExp r) {
            BooleanQuery combined;
            ArrayList<Query> queries = new ArrayList<Query>();
            WildcardFieldType.findLeaves(r.exp1, RegExp.Kind.REGEXP_CONCATENATION, queries);
            WildcardFieldType.findLeaves(r.exp2, RegExp.Kind.REGEXP_CONCATENATION, queries);
            BooleanQuery.Builder bAnd = new BooleanQuery.Builder();
            StringBuilder sequence = new StringBuilder();
            for (Query query : queries) {
                if (query instanceof TermQuery) {
                    TermQuery tq = (TermQuery)query;
                    sequence.append(tq.getTerm().text());
                    continue;
                }
                if (sequence.length() > 0) {
                    bAnd.add(new TermQuery(new Term("", sequence.toString())), BooleanClause.Occur.FILTER);
                    sequence = new StringBuilder();
                }
                bAnd.add(query, BooleanClause.Occur.FILTER);
            }
            if (sequence.length() > 0) {
                bAnd.add(new TermQuery(new Term("", sequence.toString())), BooleanClause.Occur.FILTER);
            }
            if ((combined = bAnd.build()).clauses().size() > 0) {
                return combined;
            }
            return new MatchAllDocsQuery();
        }

        private static Query createCharacterClassQuery(RegExp r) {
            ArrayList<Query> queries = new ArrayList<Query>();
            if (r.from.length > 10) {
                return new MatchAllDocsQuery();
            }
            for (int i = 0; i < r.from.length; ++i) {
                if (r.from[i] != r.to[i]) {
                    return new MatchAllDocsQuery();
                }
                String cs = Character.toString(r.from[i]);
                String normalizedChar = WildcardFieldType.toLowerCase(cs);
                queries.add(new TermQuery(new Term("", normalizedChar)));
            }
            return WildcardFieldType.formQuery(queries);
        }

        private static Query createUnionQuery(RegExp r) {
            ArrayList<Query> queries = new ArrayList<Query>();
            WildcardFieldType.findLeaves(r.exp1, RegExp.Kind.REGEXP_UNION, queries);
            WildcardFieldType.findLeaves(r.exp2, RegExp.Kind.REGEXP_UNION, queries);
            return WildcardFieldType.formQuery(queries);
        }

        private static Query formQuery(List<Query> queries) {
            BooleanQuery.Builder bOr = new BooleanQuery.Builder();
            HashSet<Query> uniqueClauses = new HashSet<Query>();
            for (Query query : queries) {
                if (!uniqueClauses.add(query)) continue;
                bOr.add(query, BooleanClause.Occur.SHOULD);
            }
            if (uniqueClauses.size() > 0) {
                if (uniqueClauses.size() == 1) {
                    return (Query)uniqueClauses.iterator().next();
                }
                return bOr.build();
            }
            return new MatchAllDocsQuery();
        }

        private static void findLeaves(RegExp exp, RegExp.Kind kind, List<Query> queries) {
            if (exp.kind == kind) {
                WildcardFieldType.findLeaves(exp.exp1, kind, queries);
                WildcardFieldType.findLeaves(exp.exp2, kind, queries);
            } else {
                queries.add(WildcardFieldType.toApproximationQuery(exp));
            }
        }

        private static String toLowerCase(String string) {
            return lowercaseNormalizer.normalize(null, string).utf8ToString();
        }

        private Query rewriteBoolToNgramQuery(Query approxQuery) {
            if (approxQuery == null) {
                return null;
            }
            if (approxQuery instanceof BooleanQuery) {
                BooleanQuery bq = (BooleanQuery)approxQuery;
                BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
                int clauseCount = 0;
                for (BooleanClause clause : bq) {
                    Query q = this.rewriteBoolToNgramQuery(clause.query());
                    if (q == null) continue;
                    if (clause.occur().equals((Object)BooleanClause.Occur.FILTER) && ++clauseCount >= 10) break;
                    rewritten.add(q, clause.occur());
                }
                return rewritten.build();
            }
            if (approxQuery instanceof TermQuery) {
                TermQuery tq = (TermQuery)approxQuery;
                String s = tq.getTerm().text();
                if (s.equals(TOKEN_START_STRING) || s.equals(TOKEN_END_STRING)) {
                    return new MatchAllDocsQuery();
                }
                LinkedHashSet<String> tokens = new LinkedHashSet<String>();
                this.getNgramTokens(tokens, s);
                BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
                for (String string : tokens) {
                    this.addClause(string, rewritten, BooleanClause.Occur.FILTER);
                }
                return rewritten.build();
            }
            if (approxQuery instanceof MatchAllDocsQuery) {
                return approxQuery;
            }
            throw new IllegalStateException("Invalid query type found parsing regex query:" + String.valueOf(approxQuery));
        }

        private void getNgramTokens(Set<String> tokens, String fragment) {
            if (fragment.equals(TOKEN_START_STRING) || fragment.equals(TOKEN_END_STRING)) {
                return;
            }
            TokenStream tokenizer = this.analyzer.tokenStream(this.name(), fragment);
            CharTermAttribute termAtt = tokenizer.addAttribute(CharTermAttribute.class);
            int foundTokens = 0;
            try {
                tokenizer.reset();
                while (tokenizer.incrementToken()) {
                    String tokenValue = termAtt.toString();
                    tokens.add(tokenValue);
                    ++foundTokens;
                }
                tokenizer.end();
                tokenizer.close();
            }
            catch (IOException ioe) {
                throw new ElasticsearchParseException("Error parsing wildcard regex pattern fragment [" + fragment + "]", new Object[0]);
            }
            if (foundTokens == 0 && fragment.length() > 0) {
                fragment = WildcardFieldType.toLowerCase(fragment);
                if (this.analyzer == WILDCARD_ANALYZER_7_10) {
                    fragment = PunctuationFoldingFilter.normalize(fragment);
                }
                tokens.add(fragment);
            }
        }

        private void addClause(String token, BooleanQuery.Builder bqBuilder, BooleanClause.Occur occur) {
            assert (token.codePointCount(0, token.length()) <= 3);
            int tokenSize = token.codePointCount(0, token.length());
            if (tokenSize < 2 || token.equals(TOKEN_END_STRING)) {
                bqBuilder.add(new BooleanClause(new MatchAllDocsQuery(), occur));
                return;
            }
            if (tokenSize == 3) {
                TermQuery tq = new TermQuery(new Term(this.name(), token));
                bqBuilder.add(new BooleanClause(tq, occur));
            } else {
                PrefixQuery wq = new PrefixQuery(new Term(this.name(), token), MultiTermQuery.CONSTANT_SCORE_REWRITE);
                bqBuilder.add(new BooleanClause(wq, occur));
            }
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
            BytesRef lower = lowerTerm == null ? null : BytesRefs.toBytesRef(lowerTerm);
            BytesRef upper = upperTerm == null ? null : BytesRefs.toBytesRef(upperTerm);
            BooleanQuery accelerationQuery = null;
            if (lowerTerm != null && upperTerm != null) {
                int cU;
                int cL;
                int length;
                StringBuilder commonPrefix = new StringBuilder();
                String lowerS = WildcardFieldMapper.addLineEndChars(lower.utf8ToString());
                String upperS = WildcardFieldMapper.addLineEndChars(upper.utf8ToString());
                for (int i = 0; i < Math.min(lowerS.length(), upperS.length()) && (cL = lowerS.codePointAt(i)) == (cU = upperS.codePointAt(i)); i += length) {
                    commonPrefix.append(Character.toChars(cL));
                    length = Character.charCount(cL);
                }
                if (commonPrefix.length() > 0) {
                    HashSet<String> tokens = new HashSet<String>();
                    this.getNgramTokens(tokens, commonPrefix.toString());
                    BooleanQuery.Builder bqBuilder = new BooleanQuery.Builder();
                    for (String token : tokens) {
                        int tokenSize = token.codePointCount(0, token.length());
                        if (tokenSize < 2 || token.equals(TOKEN_END_STRING)) continue;
                        if (tokenSize == 3) {
                            TermQuery tq = new TermQuery(new Term(this.name(), token));
                            bqBuilder.add(new BooleanClause(tq, BooleanClause.Occur.FILTER));
                            continue;
                        }
                        PrefixQuery wq = new PrefixQuery(new Term(this.name(), token), MultiTermQuery.CONSTANT_SCORE_REWRITE);
                        bqBuilder.add(new BooleanClause(wq, BooleanClause.Occur.FILTER));
                    }
                    BooleanQuery bq = bqBuilder.build();
                    if (bq.clauses().size() > 0) {
                        accelerationQuery = bq;
                    }
                }
            }
            Automaton automaton = TermRangeQuery.toAutomaton(lower, upper, includeLower, includeUpper);
            if (accelerationQuery == null) {
                return BinaryDvConfirmedQuery.fromAutomaton(new MatchAllDocsQuery(), this.name(), String.valueOf(lower) + "-" + String.valueOf(upper), automaton);
            }
            return BinaryDvConfirmedQuery.fromAutomaton(accelerationQuery, this.name(), String.valueOf(lower) + "-" + String.valueOf(upper), automaton);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
            String searchTerm = BytesRefs.toString(value);
            try {
                FuzzyQuery fq;
                BooleanQuery.Builder approxBuilder = new BooleanQuery.Builder();
                String postPrefixString = searchTerm;
                if (prefixLength > 0) {
                    LinkedHashSet<String> prefixTokens = new LinkedHashSet<String>();
                    postPrefixString = searchTerm.substring(prefixLength);
                    String prefixCandidate = "\u0000" + searchTerm.substring(0, prefixLength);
                    this.getNgramTokens(prefixTokens, prefixCandidate);
                    for (String prefixToken : prefixTokens) {
                        this.addClause(prefixToken, approxBuilder, BooleanClause.Occur.MUST);
                    }
                }
                TokenStream tokenizer = this.analyzer.tokenStream(this.name(), postPrefixString);
                CharTermAttribute termAtt = tokenizer.addAttribute(CharTermAttribute.class);
                ArrayList<String> postPrefixTokens = new ArrayList<String>();
                String firstToken = null;
                tokenizer.reset();
                int tokenNumber = 0;
                while (tokenizer.incrementToken()) {
                    if (tokenNumber == 0) {
                        String token = termAtt.toString();
                        if (firstToken == null) {
                            firstToken = token;
                        }
                        postPrefixTokens.add(token);
                    }
                    if (++tokenNumber != 3) continue;
                    tokenNumber = 0;
                }
                tokenizer.end();
                tokenizer.close();
                BooleanQuery.Builder ngramBuilder = new BooleanQuery.Builder();
                int numClauses = 0;
                for (String token : postPrefixTokens) {
                    this.addClause(token, ngramBuilder, BooleanClause.Occur.SHOULD);
                    ++numClauses;
                }
                if (numClauses > fuzziness.asDistance(searchTerm)) {
                    ngramBuilder.setMinimumNumberShouldMatch(numClauses - fuzziness.asDistance(searchTerm));
                    approxBuilder.add(ngramBuilder.build(), BooleanClause.Occur.MUST);
                }
                BooleanQuery ngramQ = approxBuilder.build();
                FuzzyQuery fuzzyQuery = fq = rewriteMethod == null ? new FuzzyQuery(new Term(this.name(), searchTerm), fuzziness.asDistance(searchTerm), prefixLength, maxExpansions, transpositions) : new FuzzyQuery(new Term(this.name(), searchTerm), fuzziness.asDistance(searchTerm), prefixLength, maxExpansions, transpositions, rewriteMethod);
                if (ngramQ.clauses().size() == 0) {
                    return BinaryDvConfirmedQuery.fromAutomaton(new MatchAllDocsQuery(), this.name(), searchTerm, fq.getAutomata().automaton);
                }
                return BinaryDvConfirmedQuery.fromAutomaton(ngramQ, this.name(), searchTerm, fq.getAutomata().automaton);
            }
            catch (IOException ioe) {
                throw new ElasticsearchParseException("Error parsing wildcard field fuzzy string [" + searchTerm + "]", new Object[0]);
            }
        }

        @Override
        public String typeName() {
            return WildcardFieldMapper.CONTENT_TYPE;
        }

        @Override
        public String familyTypeName() {
            return "keyword";
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            String searchTerm = BytesRefs.toString(value);
            BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
            Integer numClauses = this.getApproxWildCardQuery(WildcardFieldType.escapeWildcardSyntax(searchTerm), rewritten);
            if (numClauses != null && numClauses > 0) {
                BooleanQuery approxQuery = rewritten.build();
                return BinaryDvConfirmedQuery.fromTerms(approxQuery, this.name(), new BytesRef(searchTerm));
            }
            return BinaryDvConfirmedQuery.fromTerms(new MatchAllDocsQuery(), this.name(), new BytesRef(searchTerm));
        }

        @Override
        public Query termsQuery(Collection<?> values, @Nullable SearchExecutionContext context) {
            Query aproxQuery;
            BytesRef[] terms = WildcardFieldType.buildTerms(values);
            if (terms.length < 16) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                for (BytesRef term : terms) {
                    BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
                    Integer numClauses = this.getApproxWildCardQuery(WildcardFieldType.escapeWildcardSyntax(term.utf8ToString()), rewritten);
                    if (numClauses == null || numClauses <= 0) continue;
                    builder.add(rewritten.build(), BooleanClause.Occur.SHOULD);
                }
                aproxQuery = builder.build();
            } else {
                LinkedHashSet<String> tokens = new LinkedHashSet<String>();
                TreeSet<BytesRef> tokenList = new TreeSet<BytesRef>();
                for (BytesRef term : terms) {
                    boolean matchAll = this.breakIntoTokens(WildcardFieldType.escapeWildcardSyntax(term.utf8ToString()), tokens);
                    assert (!matchAll);
                    if (!tokens.isEmpty()) {
                        tokenList.add(WildcardFieldType.getMiddleToken(tokens));
                    }
                    tokens.clear();
                }
                aproxQuery = new TermInSetQuery(this.name(), tokenList);
            }
            return BinaryDvConfirmedQuery.fromTerms(new ConstantScoreQuery(aproxQuery), this.name(), terms);
        }

        private static BytesRef getMiddleToken(Set<String> tokens) {
            int mid = (tokens.size() + 1) / 2;
            Iterator<String> iterator = tokens.iterator();
            for (int i = 0; i < mid - 1; ++i) {
                iterator.next();
            }
            assert (iterator.hasNext());
            return BytesRefs.toBytesRef(iterator.next());
        }

        private static BytesRef[] buildTerms(Collection<?> values) {
            HashSet dedupe = new HashSet(values);
            BytesRef[] terms = new BytesRef[dedupe.size()];
            Iterator iterator = dedupe.iterator();
            for (int i = 0; i < dedupe.size(); ++i) {
                terms[i] = BytesRefs.toBytesRef(iterator.next());
            }
            return terms;
        }

        private static String escapeWildcardSyntax(String term) {
            int length;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < term.length(); i += length) {
                int c = term.codePointAt(i);
                length = Character.charCount(c);
                if (c == 42 || c == 63 || c == 92) {
                    result.append("\\");
                }
                result.appendCodePoint(c);
            }
            return result.toString();
        }

        @Override
        public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
            String searchTerm = BytesRefs.toString(value);
            return this.wildcardQuery(WildcardFieldType.escapeWildcardSyntax(searchTerm), MultiTermQuery.CONSTANT_SCORE_REWRITE, true, context);
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            return this.wildcardQuery(WildcardFieldType.escapeWildcardSyntax(value) + "*", method, caseInsensitive, context);
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.hasDocValues()) {
                return new BlockDocValuesReader.BytesRefsFromBinaryBlockLoader(this.name());
            }
            return null;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> new StringBinaryIndexFieldData(this.name(), CoreValuesSourceType.KEYWORD, WildcardDocValuesField::new);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (keywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    return keywordValue;
                }
            };
        }
    }

    private class WildcardSyntheticFieldLoader
    implements CompositeSyntheticFieldLoader.DocValuesLayer {
        private final ByteArrayStreamInput docValuesStream = new ByteArrayStreamInput();
        private int docValueCount;
        private BytesRef docValueBytes;

        private WildcardSyntheticFieldLoader() {
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            BinaryDocValues values = leafReader.getBinaryDocValues(WildcardFieldMapper.this.fullPath());
            if (values == null) {
                this.docValueCount = 0;
                return null;
            }
            return docId -> {
                if (!values.advanceExact(docId)) {
                    this.docValueCount = 0;
                    return this.hasValue();
                }
                this.docValueBytes = values.binaryValue();
                this.docValuesStream.reset(this.docValueBytes.bytes);
                this.docValuesStream.setPosition(this.docValueBytes.offset);
                this.docValueCount = this.docValuesStream.readVInt();
                return this.hasValue();
            };
        }

        @Override
        public boolean hasValue() {
            return this.docValueCount > 0;
        }

        @Override
        public long valueCount() {
            return this.docValueCount;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            for (int i = 0; i < this.docValueCount; ++i) {
                int length = this.docValuesStream.readVInt();
                b.utf8Value(this.docValueBytes.bytes, this.docValuesStream.getPosition(), length);
                this.docValuesStream.skipBytes(length);
            }
        }

        @Override
        public String fieldName() {
            return WildcardFieldMapper.this.fullPath();
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final TextSearchInfo TEXT_SEARCH_INFO;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setStoreTermVectorOffsets(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
            TEXT_SEARCH_INFO = new TextSearchInfo(FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        }
    }

    public static final class PunctuationFoldingFilter
    extends TokenFilter {
        private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

        public PunctuationFoldingFilter(TokenStream in) {
            super(in);
        }

        @Override
        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                PunctuationFoldingFilter.normalize(this.termAtt.buffer(), 0, this.termAtt.length());
                return true;
            }
            return false;
        }

        public static String normalize(String s) {
            char[] chars = s.toCharArray();
            PunctuationFoldingFilter.normalize(chars, 0, chars.length);
            return new String(chars);
        }

        public static void normalize(char[] buffer, int offset, int limit) {
            int codepoint;
            assert (buffer.length >= limit);
            assert (0 <= offset && offset <= buffer.length);
            for (int i = offset; i < limit; i += Character.toChars(PunctuationFoldingFilter.normalize(codepoint), buffer, i)) {
                codepoint = Character.codePointAt(buffer, i, limit);
            }
        }

        private static int normalize(int codepoint) {
            if (codepoint == 0) {
                return codepoint;
            }
            if (!Character.isLetterOrDigit(codepoint)) {
                return 47;
            }
            if (codepoint > 48 && codepoint <= 128 && codepoint % 2 == 0) {
                return codepoint - 1;
            }
            return codepoint;
        }
    }
}

