/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.common.notifications.Level;

public class AuditMlNotificationAction
extends ActionType<AcknowledgedResponse> {
    public static final AuditMlNotificationAction INSTANCE = new AuditMlNotificationAction();
    public static final String NAME = "cluster:internal/xpack/ml/notification";

    private AuditMlNotificationAction() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest {
        private final AuditType auditType;
        private final String id;
        private final String message;
        private final Level level;

        public Request(AuditType auditType, String id, String message, Level level) {
            this.auditType = Objects.requireNonNull(auditType);
            this.id = Objects.requireNonNull(id);
            this.message = Objects.requireNonNull(message);
            this.level = Objects.requireNonNull(level);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.auditType = in.readEnum(AuditType.class);
            this.id = in.readString();
            this.message = in.readString();
            this.level = in.readEnum(Level.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeEnum(this.auditType);
            out.writeString(this.id);
            out.writeString(this.message);
            out.writeEnum(this.level);
        }

        public AuditType getAuditType() {
            return this.auditType;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        public Level getLevel() {
            return this.level;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.id, request.id) && Objects.equals(this.message, request.message) && this.auditType == request.auditType && this.level == request.level;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.auditType, this.id, this.message, this.level});
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }

    public static enum AuditType {
        ANOMALY_DETECTION,
        DATAFRAME_ANALYTICS,
        INFERENCE,
        SYSTEM;

    }
}

