/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xpack.core.inference.results.EmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;

public record ChunkedInferenceEmbedding(List<EmbeddingResults.Chunk> chunks) implements ChunkedInference
{
    public static List<ChunkedInference> listOf(List<String> inputs, SparseEmbeddingResults sparseEmbeddingResults) {
        TextEmbeddingUtils.validateInputSizeAgainstEmbeddings(inputs, sparseEmbeddingResults.embeddings().size());
        ArrayList<ChunkedInference> results = new ArrayList<ChunkedInference>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            results.add(new ChunkedInferenceEmbedding(List.of(new EmbeddingResults.Chunk(sparseEmbeddingResults.embeddings().get(i), new ChunkedInference.TextOffset(0, inputs.get(i).length())))));
        }
        return results;
    }

    @Override
    public Iterator<ChunkedInference.Chunk> chunksAsByteReference(XContent xcontent) throws IOException {
        ArrayList<ChunkedInference.Chunk> chunkedInferenceChunks = new ArrayList<ChunkedInference.Chunk>();
        for (EmbeddingResults.Chunk embeddingResultsChunk : this.chunks()) {
            chunkedInferenceChunks.add(new ChunkedInference.Chunk(embeddingResultsChunk.offset(), embeddingResultsChunk.embedding().toBytesRef(xcontent)));
        }
        return chunkedInferenceChunks.iterator();
    }
}

