/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.elasticsearch.core.IOUtils;

public class Streams {
    private static final ThreadLocal<byte[]> LOCAL_BUFFER = ThreadLocal.withInitial(() -> new byte[8192]);

    private Streams() {
    }

    public static long copy(InputStream in, OutputStream out, byte[] buffer, boolean close) throws IOException {
        long l;
        block6: {
            Exception err = null;
            try {
                int bytesRead;
                long byteCount = 0L;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                    byteCount += (long)bytesRead;
                }
                out.flush();
                l = byteCount;
                if (!close) break block6;
            }
            catch (IOException | RuntimeException e) {
                try {
                    err = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (close) {
                        IOUtils.close(err, in, out);
                    }
                    throw throwable;
                }
            }
            IOUtils.close(err, in, out);
        }
        return l;
    }

    public static long copy(InputStream in, OutputStream out, boolean close) throws IOException {
        return Streams.copy(in, out, LOCAL_BUFFER.get(), close);
    }

    public static long copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        return Streams.copy(in, out, buffer, true);
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return Streams.copy(in, out, LOCAL_BUFFER.get(), true);
    }

    public static int read(InputStream input, ByteBuffer buffer, int count) throws IOException {
        if (buffer.hasArray()) {
            return Streams.readToHeapBuffer(input, buffer, count);
        }
        return Streams.readToDirectBuffer(input, buffer, count);
    }

    private static int readToHeapBuffer(InputStream input, ByteBuffer buffer, int count) throws IOException {
        int pos = buffer.position();
        int read = Streams.readFully(input, buffer.array(), buffer.arrayOffset() + pos, count);
        if (read > 0) {
            buffer.position(pos + read);
        }
        return read;
    }

    private static int readToDirectBuffer(InputStream input, ByteBuffer b, int count) throws IOException {
        int len;
        int totalRead;
        int read;
        byte[] buffer = LOCAL_BUFFER.get();
        for (totalRead = 0; totalRead < count && (read = input.read(buffer, 0, len = Math.min(count - totalRead, buffer.length))) != -1; totalRead += read) {
            b.put(buffer, 0, read);
        }
        return totalRead;
    }

    public static int readFully(InputStream reader, byte[] dest) throws IOException {
        return Streams.readFully(reader, dest, 0, dest.length);
    }

    public static int readFully(InputStream reader, byte[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static OutputStream noCloseStream(OutputStream stream) {
        return new FilterOutputStream(stream){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void close() {
            }
        };
    }
}

