/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.CohereServiceSettings;
import co.elastic.clients.elasticsearch.inference.CohereServiceType;
import co.elastic.clients.elasticsearch.inference.CohereTaskSettings;
import co.elastic.clients.elasticsearch.inference.CohereTaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutCohereResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutCohereRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String cohereInferenceId;
    private final CohereServiceType service;
    private final CohereServiceSettings serviceSettings;
    @Nullable
    private final CohereTaskSettings taskSettings;
    private final CohereTaskType taskType;
    public static final JsonpDeserializer<PutCohereRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutCohereRequest::setupPutCohereRequestDeserializer);
    public static final Endpoint<PutCohereRequest, PutCohereResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutCohereRequest, PutCohereResponse>("es/inference.put_cohere", request -> "PUT", request -> {
        boolean _cohereInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.cohereInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _cohereInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("cohereInferenceId", request.cohereInferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutCohereResponse._DESERIALIZER);

    private PutCohereRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.cohereInferenceId = ApiTypeHelper.requireNonNull(builder.cohereInferenceId, this, "cohereInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
    }

    public static PutCohereRequest of(Function<Builder, ObjectBuilder<PutCohereRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String cohereInferenceId() {
        return this.cohereInferenceId;
    }

    public final CohereServiceType service() {
        return this.service;
    }

    public final CohereServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final CohereTaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final CohereTaskType taskType() {
        return this.taskType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    protected static void setupPutCohereRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, CohereServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, CohereServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, CohereTaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutCohereRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String cohereInferenceId;
        private CohereServiceType service;
        private CohereServiceSettings serviceSettings;
        @Nullable
        private CohereTaskSettings taskSettings;
        private CohereTaskType taskType;

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder cohereInferenceId(String value) {
            this.cohereInferenceId = value;
            return this;
        }

        public final Builder service(CohereServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(CohereServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<CohereServiceSettings.Builder, ObjectBuilder<CohereServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new CohereServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable CohereTaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<CohereTaskSettings.Builder, ObjectBuilder<CohereTaskSettings>> fn) {
            return this.taskSettings(fn.apply(new CohereTaskSettings.Builder()).build());
        }

        public final Builder taskType(CohereTaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutCohereRequest build() {
            this._checkSingleUse();
            return new PutCohereRequest(this);
        }
    }
}

