/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RestrictedIndices;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ApplicationPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.LimitedRole;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissionGroup;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteIndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.core.security.authz.permission.SimpleRole;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.authz.restriction.WorkflowsRestriction;
import org.elasticsearch.xpack.core.security.support.Automatons;

public interface Role {
    public static final String REMOTE_USER_ROLE_NAME = "_remote_user";
    public static final Role EMPTY;
    public static final Role EMPTY_RESTRICTED_BY_WORKFLOW;

    public String[] names();

    public ClusterPermission cluster();

    public IndicesPermission indices();

    public ApplicationPermission application();

    public RunAsPermission runAs();

    public RemoteIndicesPermission remoteIndices();

    public RemoteClusterPermissions remoteCluster();

    public boolean hasWorkflowsRestriction();

    public Role forWorkflow(@Nullable String var1);

    public boolean hasFieldOrDocumentLevelSecurity();

    public IndicesPermission.IsResourceAuthorizedPredicate allowedIndicesMatcher(String var1);

    public Automaton allowedActionsMatcher(String var1);

    public boolean checkRunAs(String var1);

    public boolean checkIndicesAction(String var1);

    public boolean checkIndicesPrivileges(Set<String> var1, boolean var2, Set<String> var3, @Nullable ResourcePrivilegesMap.Builder var4);

    public boolean checkClusterAction(String var1, TransportRequest var2, Authentication var3);

    public boolean grants(ClusterPrivilege var1);

    public boolean checkApplicationResourcePrivileges(String var1, Set<String> var2, Set<String> var3, Collection<ApplicationPrivilegeDescriptor> var4, @Nullable ResourcePrivilegesMap.Builder var5);

    public IndicesAccessControl authorize(String var1, Set<String> var2, ProjectMetadata var3, FieldPermissionsCache var4);

    public RoleDescriptorsIntersection getRoleDescriptorsIntersectionForRemoteCluster(String var1, TransportVersion var2);

    default public Role limitedBy(Role role) {
        return new LimitedRole(this, role);
    }

    public static Builder builder(RestrictedIndices restrictedIndices, String ... names) {
        return new Builder(restrictedIndices, names);
    }

    public static SimpleRole buildFromRoleDescriptor(RoleDescriptor roleDescriptor, FieldPermissionsCache fieldPermissionsCache, RestrictedIndices restrictedIndices) {
        return Role.buildFromRoleDescriptor(roleDescriptor, fieldPermissionsCache, restrictedIndices, List.of());
    }

    /*
     * WARNING - void declaration
     */
    public static SimpleRole buildFromRoleDescriptor(RoleDescriptor roleDescriptor, FieldPermissionsCache fieldPermissionsCache, RestrictedIndices restrictedIndices, Collection<ApplicationPrivilegeDescriptor> storedApplicationPrivilegeDescriptors) {
        void var8_16;
        Objects.requireNonNull(fieldPermissionsCache);
        Builder builder = Role.builder(restrictedIndices, roleDescriptor.getName());
        builder.cluster(Sets.newHashSet(roleDescriptor.getClusterPrivileges()), Arrays.asList(roleDescriptor.getConditionalClusterPrivileges()));
        for (RoleDescriptor.IndicesPrivileges indicesPrivileges : roleDescriptor.getIndicesPrivileges()) {
            builder.add(fieldPermissionsCache.getFieldPermissions(new FieldPermissionsDefinition(indicesPrivileges.getGrantedFields(), indicesPrivileges.getDeniedFields())), indicesPrivileges.getQuery() == null ? null : Collections.singleton(indicesPrivileges.getQuery()), IndexPrivilege.resolveBySelectorAccess(Set.of(indicesPrivileges.getPrivileges())), indicesPrivileges.allowRestrictedIndices(), indicesPrivileges.getIndices());
        }
        for (ToXContentObject toXContentObject : roleDescriptor.getRemoteIndicesPrivileges()) {
            Object[] clusterAliases = ((RoleDescriptor.RemoteIndicesPrivileges)toXContentObject).remoteClusters();
            if (!1.$assertionsDisabled && !Arrays.equals(new String[]{"*"}, clusterAliases)) {
                throw new AssertionError((Object)"reserved role should not define remote indices privileges for specific clusters");
            }
            RoleDescriptor.IndicesPrivileges indicesPrivileges = ((RoleDescriptor.RemoteIndicesPrivileges)toXContentObject).indicesPrivileges();
            builder.addRemoteIndicesGroup(Set.of(clusterAliases), fieldPermissionsCache.getFieldPermissions(new FieldPermissionsDefinition(indicesPrivileges.getGrantedFields(), indicesPrivileges.getDeniedFields())), indicesPrivileges.getQuery() == null ? null : Collections.singleton(indicesPrivileges.getQuery()), IndexPrivilege.resolveBySelectorAccess(Set.of(indicesPrivileges.getPrivileges())), indicesPrivileges.allowRestrictedIndices(), indicesPrivileges.getIndices());
        }
        RemoteClusterPermissions remoteClusterPermissions = roleDescriptor.getRemoteClusterPermissions();
        for (RemoteClusterPermissionGroup group : remoteClusterPermissions.groups()) {
            Object[] objectArray = group.remoteClusterAliases();
            if (!1.$assertionsDisabled && !Arrays.equals(new String[]{"*"}, objectArray)) {
                throw new AssertionError((Object)"reserved role should not define remote cluster privileges for specific clusters");
            }
        }
        builder.addRemoteClusterPermissions(remoteClusterPermissions);
        RoleDescriptor.ApplicationResourcePrivileges[] applicationResourcePrivilegesArray = roleDescriptor.getApplicationPrivileges();
        int n = applicationResourcePrivilegesArray.length;
        boolean bl = false;
        while (var8_16 < n) {
            RoleDescriptor.ApplicationResourcePrivileges applicationPrivilege = applicationResourcePrivilegesArray[var8_16];
            ApplicationPrivilege.get(applicationPrivilege.getApplication(), Sets.newHashSet(applicationPrivilege.getPrivileges()), storedApplicationPrivilegeDescriptors).forEach(priv -> builder.addApplicationPrivilege((ApplicationPrivilege)priv, (Set<String>)Sets.newHashSet(applicationPrivilege.getResources())));
            ++var8_16;
        }
        String[] rdRunAs = roleDescriptor.getRunAs();
        if (rdRunAs != null && rdRunAs.length > 0) {
            builder.runAs(new Privilege(Sets.newHashSet(rdRunAs), rdRunAs));
        }
        if (roleDescriptor.hasWorkflowsRestriction()) {
            builder.workflows(Sets.newHashSet(roleDescriptor.getRestriction().getWorkflows()));
        }
        return builder.build();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        EMPTY = Role.builder(new RestrictedIndices(Automatons.EMPTY), new String[0]).build();
        EMPTY_RESTRICTED_BY_WORKFLOW = Role.builder(new RestrictedIndices(Automatons.EMPTY), new String[0]).workflows(Set.of()).build();
    }

    public static class Builder {
        private final String[] names;
        private ClusterPermission cluster = ClusterPermission.NONE;
        private RunAsPermission runAs = RunAsPermission.NONE;
        private final List<IndicesPermissionGroupDefinition> groups = new ArrayList<IndicesPermissionGroupDefinition>();
        private final Map<Set<String>, List<IndicesPermissionGroupDefinition>> remoteIndicesGroups = new HashMap<Set<String>, List<IndicesPermissionGroupDefinition>>();
        private final List<Tuple<ApplicationPrivilege, Set<String>>> applicationPrivs = new ArrayList<Tuple<ApplicationPrivilege, Set<String>>>();
        private final RestrictedIndices restrictedIndices;
        private WorkflowsRestriction workflowsRestriction = WorkflowsRestriction.NONE;
        private RemoteClusterPermissions remoteClusterPermissions = null;

        private Builder(RestrictedIndices restrictedIndices, String[] names) {
            this.restrictedIndices = restrictedIndices;
            this.names = names;
        }

        public Builder cluster(Set<String> privilegeNames, Iterable<ConfigurableClusterPrivilege> configurableClusterPrivileges) {
            ClusterPermission.Builder builder = new ClusterPermission.Builder(this.restrictedIndices);
            if (!privilegeNames.isEmpty()) {
                for (String name : privilegeNames) {
                    builder = ClusterPrivilegeResolver.resolve(name).buildPermission(builder);
                }
            }
            for (ConfigurableClusterPrivilege ccp : configurableClusterPrivileges) {
                builder = ccp.buildPermission(builder);
            }
            this.cluster = builder.build();
            return this;
        }

        public Builder runAs(Privilege privilege) {
            this.runAs = new RunAsPermission(privilege);
            return this;
        }

        public Builder add(IndexPrivilege privilege, String ... indices) {
            return this.add(FieldPermissions.DEFAULT, null, privilege, false, indices);
        }

        public Builder add(FieldPermissions fieldPermissions, Set<BytesReference> query, Set<IndexPrivilege> privilegesSplitBySelector, boolean allowRestrictedIndices, String ... indices) {
            for (IndexPrivilege indexPrivilege : privilegesSplitBySelector) {
                this.add(fieldPermissions, query, indexPrivilege, allowRestrictedIndices, indices);
            }
            return this;
        }

        public Builder add(FieldPermissions fieldPermissions, Set<BytesReference> query, IndexPrivilege privilege, boolean allowRestrictedIndices, String ... indices) {
            this.groups.add(new IndicesPermissionGroupDefinition(privilege, fieldPermissions, query, allowRestrictedIndices, indices));
            return this;
        }

        public Builder addRemoteIndicesGroup(Set<String> remoteClusterAliases, FieldPermissions fieldPermissions, Set<BytesReference> query, Set<IndexPrivilege> privilegesSplitBySelector, boolean allowRestrictedIndices, String ... indices) {
            for (IndexPrivilege indexPrivilege : privilegesSplitBySelector) {
                this.addRemoteIndicesGroup(remoteClusterAliases, fieldPermissions, query, indexPrivilege, allowRestrictedIndices, indices);
            }
            return this;
        }

        public Builder addRemoteIndicesGroup(Set<String> remoteClusterAliases, FieldPermissions fieldPermissions, Set<BytesReference> query, IndexPrivilege privilege, boolean allowRestrictedIndices, String ... indices) {
            this.remoteIndicesGroups.computeIfAbsent(remoteClusterAliases, k -> new ArrayList()).add(new IndicesPermissionGroupDefinition(privilege, fieldPermissions, query, allowRestrictedIndices, indices));
            return this;
        }

        public Builder addRemoteClusterPermissions(RemoteClusterPermissions remoteClusterPermissions) {
            Objects.requireNonNull(remoteClusterPermissions, "remoteClusterPermissions must not be null");
            assert (this.remoteClusterPermissions == null) : "addRemoteClusterPermissions should only be called once";
            if (remoteClusterPermissions.hasAnyPrivileges()) {
                remoteClusterPermissions.validate();
            }
            this.remoteClusterPermissions = remoteClusterPermissions;
            return this;
        }

        public Builder addApplicationPrivilege(ApplicationPrivilege privilege, Set<String> resources) {
            this.applicationPrivs.add(new Tuple<ApplicationPrivilege, Set<String>>(privilege, resources));
            return this;
        }

        public Builder workflows(Set<String> workflowNames) {
            this.workflowsRestriction = workflowNames == null ? WorkflowsRestriction.NONE : new WorkflowsRestriction(workflowNames);
            return this;
        }

        public SimpleRole build() {
            RemoteIndicesPermission remoteIndicesPermission;
            IndicesPermission indices;
            if (this.groups.isEmpty()) {
                indices = IndicesPermission.NONE;
            } else {
                IndicesPermission.Builder indicesBuilder = new IndicesPermission.Builder(this.restrictedIndices);
                for (IndicesPermissionGroupDefinition group : this.groups) {
                    indicesBuilder.addGroup(group.privilege, group.fieldPermissions, group.query, group.allowRestrictedIndices, group.indices);
                }
                indices = indicesBuilder.build();
            }
            if (this.remoteIndicesGroups.isEmpty()) {
                remoteIndicesPermission = RemoteIndicesPermission.NONE;
            } else {
                RemoteIndicesPermission.Builder remoteIndicesBuilder = new RemoteIndicesPermission.Builder();
                for (Map.Entry<Set<String>, List<IndicesPermissionGroupDefinition>> remoteGroupEntry : this.remoteIndicesGroups.entrySet()) {
                    Set<String> clusterAlias = remoteGroupEntry.getKey();
                    for (IndicesPermissionGroupDefinition group : remoteGroupEntry.getValue()) {
                        remoteIndicesBuilder.addGroup(clusterAlias, group.privilege, group.fieldPermissions, group.query, group.allowRestrictedIndices, group.indices);
                    }
                }
                remoteIndicesPermission = remoteIndicesBuilder.build();
            }
            ApplicationPermission applicationPermission = this.applicationPrivs.isEmpty() ? ApplicationPermission.NONE : new ApplicationPermission(this.applicationPrivs);
            return new SimpleRole(this.names, this.cluster, indices, applicationPermission, this.runAs, remoteIndicesPermission, this.remoteClusterPermissions == null ? RemoteClusterPermissions.NONE : this.remoteClusterPermissions, this.workflowsRestriction);
        }

        private static class IndicesPermissionGroupDefinition {
            private final IndexPrivilege privilege;
            private final FieldPermissions fieldPermissions;
            @Nullable
            private final Set<BytesReference> query;
            private final boolean allowRestrictedIndices;
            private final String[] indices;

            private IndicesPermissionGroupDefinition(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, boolean allowRestrictedIndices, String ... indices) {
                this.privilege = privilege;
                this.fieldPermissions = fieldPermissions;
                this.query = query;
                this.allowRestrictedIndices = allowRestrictedIndices;
                this.indices = indices;
            }
        }
    }
}

