/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.plain.FormattedSortedNumericDocValues;
import org.elasticsearch.index.fielddata.plain.LeafLongFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class SortedNumericIndexFieldData
extends IndexNumericFieldData {
    private final IndexNumericFieldData.NumericType numericType;
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;
    protected final ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory;
    protected final boolean indexed;

    public SortedNumericIndexFieldData(String fieldName, IndexNumericFieldData.NumericType numericType, ValuesSourceType valuesSourceType, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory, boolean indexed) {
        this.fieldName = fieldName;
        this.numericType = Objects.requireNonNull(numericType);
        assert (!this.numericType.isFloatingPoint());
        this.valuesSourceType = valuesSourceType;
        this.toScriptFieldFactory = toScriptFieldFactory;
        this.indexed = indexed;
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return false;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    protected IndexFieldData.XFieldComparatorSource dateComparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        if (this.numericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS) {
            return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> SortedNumericIndexFieldData.convertNumeric(dvs, DateUtils::toMilliSeconds), IndexNumericFieldData.NumericType.DATE);
        }
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, IndexNumericFieldData.NumericType.DATE);
    }

    @Override
    protected IndexFieldData.XFieldComparatorSource dateNanosComparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        if (this.numericType == IndexNumericFieldData.NumericType.DATE) {
            return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> SortedNumericIndexFieldData.convertNumeric(dvs, DateUtils::toNanoSeconds), IndexNumericFieldData.NumericType.DATE_NANOSECONDS);
        }
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, IndexNumericFieldData.NumericType.DATE_NANOSECONDS);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    @Override
    public LeafNumericFieldData loadDirect(LeafReaderContext context) {
        return this.load(context);
    }

    @Override
    public LeafNumericFieldData load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        String field = this.fieldName;
        if (this.numericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS) {
            return new NanoSecondFieldData(reader, field, this.toScriptFieldFactory);
        }
        return new SortedNumericLongFieldData(reader, field, this.toScriptFieldFactory);
    }

    public static final class NanoSecondFieldData
    extends LeafLongFieldData {
        private final LeafReader reader;
        private final String fieldName;
        protected final ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory;

        NanoSecondFieldData(LeafReader reader, String fieldName, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
            super(0L);
            this.reader = reader;
            this.fieldName = fieldName;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            return SortedNumericIndexFieldData.convertNumeric(this.getLongValuesAsNanos(), DateUtils::toMilliSeconds);
        }

        public SortedNumericDocValues getLongValuesAsNanos() {
            try {
                return DocValues.getSortedNumeric(this.reader, this.fieldName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(this.getLongValuesAsNanos(), name);
        }

        @Override
        public FormattedDocValues getFormattedValues(DocValueFormat format) {
            return new FormattedSortedNumericDocValues(this.getLongValuesAsNanos(), DocValueFormat.withNanosecondResolution(format));
        }
    }

    static final class SortedNumericLongFieldData
    extends LeafLongFieldData {
        final LeafReader reader;
        final String field;
        protected final ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory;

        SortedNumericLongFieldData(LeafReader reader, String field, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
            super(0L);
            this.reader = reader;
            this.field = field;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            try {
                return DocValues.getSortedNumeric(this.reader, this.field);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(this.getLongValues(), name);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final IndexNumericFieldData.NumericType numericType;
        private final ValuesSourceType valuesSourceType;
        protected final ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory;
        private final boolean indexed;

        public Builder(String name, IndexNumericFieldData.NumericType numericType, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory, boolean indexed) {
            this(name, numericType, numericType.getValuesSourceType(), toScriptFieldFactory, indexed);
        }

        public Builder(String name, IndexNumericFieldData.NumericType numericType, ValuesSourceType valuesSourceType, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory, boolean indexed) {
            this.name = name;
            this.numericType = numericType;
            this.valuesSourceType = valuesSourceType;
            this.toScriptFieldFactory = toScriptFieldFactory;
            this.indexed = indexed;
        }

        public SortedNumericIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SortedNumericIndexFieldData(this.name, this.numericType, this.valuesSourceType, this.toScriptFieldFactory, this.indexed);
        }
    }
}

