/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AdaptiveSelection
implements JsonpSerializable {
    @Nullable
    private final Long avgQueueSize;
    @Nullable
    private final Time avgResponseTime;
    @Nullable
    private final Long avgResponseTimeNs;
    @Nullable
    private final Time avgServiceTime;
    @Nullable
    private final Long avgServiceTimeNs;
    @Nullable
    private final Long outgoingSearches;
    @Nullable
    private final String rank;
    public static final JsonpDeserializer<AdaptiveSelection> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AdaptiveSelection::setupAdaptiveSelectionDeserializer);

    private AdaptiveSelection(Builder builder) {
        this.avgQueueSize = builder.avgQueueSize;
        this.avgResponseTime = builder.avgResponseTime;
        this.avgResponseTimeNs = builder.avgResponseTimeNs;
        this.avgServiceTime = builder.avgServiceTime;
        this.avgServiceTimeNs = builder.avgServiceTimeNs;
        this.outgoingSearches = builder.outgoingSearches;
        this.rank = builder.rank;
    }

    public static AdaptiveSelection of(Function<Builder, ObjectBuilder<AdaptiveSelection>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long avgQueueSize() {
        return this.avgQueueSize;
    }

    @Nullable
    public final Time avgResponseTime() {
        return this.avgResponseTime;
    }

    @Nullable
    public final Long avgResponseTimeNs() {
        return this.avgResponseTimeNs;
    }

    @Nullable
    public final Time avgServiceTime() {
        return this.avgServiceTime;
    }

    @Nullable
    public final Long avgServiceTimeNs() {
        return this.avgServiceTimeNs;
    }

    @Nullable
    public final Long outgoingSearches() {
        return this.outgoingSearches;
    }

    @Nullable
    public final String rank() {
        return this.rank;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.avgQueueSize != null) {
            generator.writeKey("avg_queue_size");
            generator.write(this.avgQueueSize);
        }
        if (this.avgResponseTime != null) {
            generator.writeKey("avg_response_time");
            this.avgResponseTime.serialize(generator, mapper);
        }
        if (this.avgResponseTimeNs != null) {
            generator.writeKey("avg_response_time_ns");
            generator.write(this.avgResponseTimeNs);
        }
        if (this.avgServiceTime != null) {
            generator.writeKey("avg_service_time");
            this.avgServiceTime.serialize(generator, mapper);
        }
        if (this.avgServiceTimeNs != null) {
            generator.writeKey("avg_service_time_ns");
            generator.write(this.avgServiceTimeNs);
        }
        if (this.outgoingSearches != null) {
            generator.writeKey("outgoing_searches");
            generator.write(this.outgoingSearches);
        }
        if (this.rank != null) {
            generator.writeKey("rank");
            generator.write(this.rank);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAdaptiveSelectionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::avgQueueSize, JsonpDeserializer.longDeserializer(), "avg_queue_size");
        op.add(Builder::avgResponseTime, Time._DESERIALIZER, "avg_response_time");
        op.add(Builder::avgResponseTimeNs, JsonpDeserializer.longDeserializer(), "avg_response_time_ns");
        op.add(Builder::avgServiceTime, Time._DESERIALIZER, "avg_service_time");
        op.add(Builder::avgServiceTimeNs, JsonpDeserializer.longDeserializer(), "avg_service_time_ns");
        op.add(Builder::outgoingSearches, JsonpDeserializer.longDeserializer(), "outgoing_searches");
        op.add(Builder::rank, JsonpDeserializer.stringDeserializer(), "rank");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AdaptiveSelection> {
        @Nullable
        private Long avgQueueSize;
        @Nullable
        private Time avgResponseTime;
        @Nullable
        private Long avgResponseTimeNs;
        @Nullable
        private Time avgServiceTime;
        @Nullable
        private Long avgServiceTimeNs;
        @Nullable
        private Long outgoingSearches;
        @Nullable
        private String rank;

        public final Builder avgQueueSize(@Nullable Long value) {
            this.avgQueueSize = value;
            return this;
        }

        public final Builder avgResponseTime(@Nullable Time value) {
            this.avgResponseTime = value;
            return this;
        }

        public final Builder avgResponseTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.avgResponseTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder avgResponseTimeNs(@Nullable Long value) {
            this.avgResponseTimeNs = value;
            return this;
        }

        public final Builder avgServiceTime(@Nullable Time value) {
            this.avgServiceTime = value;
            return this;
        }

        public final Builder avgServiceTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.avgServiceTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder avgServiceTimeNs(@Nullable Long value) {
            this.avgServiceTimeNs = value;
            return this;
        }

        public final Builder outgoingSearches(@Nullable Long value) {
            this.outgoingSearches = value;
            return this;
        }

        public final Builder rank(@Nullable String value) {
            this.rank = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AdaptiveSelection build() {
            this._checkSingleUse();
            return new AdaptiveSelection(this);
        }
    }
}

