/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.elasticsearch._types.analysis.WordDelimiterTokenFilterBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WordDelimiterGraphTokenFilter
extends WordDelimiterTokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Boolean adjustOffsets;
    @Nullable
    private final Boolean ignoreKeywords;
    public static final JsonpDeserializer<WordDelimiterGraphTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WordDelimiterGraphTokenFilter::setupWordDelimiterGraphTokenFilterDeserializer);

    private WordDelimiterGraphTokenFilter(Builder builder) {
        super(builder);
        this.adjustOffsets = builder.adjustOffsets;
        this.ignoreKeywords = builder.ignoreKeywords;
    }

    public static WordDelimiterGraphTokenFilter of(Function<Builder, ObjectBuilder<WordDelimiterGraphTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.WordDelimiterGraph;
    }

    @Nullable
    public final Boolean adjustOffsets() {
        return this.adjustOffsets;
    }

    @Nullable
    public final Boolean ignoreKeywords() {
        return this.ignoreKeywords;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "word_delimiter_graph");
        super.serializeInternal(generator, mapper);
        if (this.adjustOffsets != null) {
            generator.writeKey("adjust_offsets");
            generator.write(this.adjustOffsets);
        }
        if (this.ignoreKeywords != null) {
            generator.writeKey("ignore_keywords");
            generator.write(this.ignoreKeywords);
        }
    }

    protected static void setupWordDelimiterGraphTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        WordDelimiterTokenFilterBase.setupWordDelimiterTokenFilterBaseDeserializer(op);
        op.add(Builder::adjustOffsets, JsonpDeserializer.booleanDeserializer(), "adjust_offsets");
        op.add(Builder::ignoreKeywords, JsonpDeserializer.booleanDeserializer(), "ignore_keywords");
        op.ignore("type");
    }

    public static class Builder
    extends WordDelimiterTokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WordDelimiterGraphTokenFilter> {
        @Nullable
        private Boolean adjustOffsets;
        @Nullable
        private Boolean ignoreKeywords;

        public final Builder adjustOffsets(@Nullable Boolean value) {
            this.adjustOffsets = value;
            return this;
        }

        public final Builder ignoreKeywords(@Nullable Boolean value) {
            this.ignoreKeywords = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WordDelimiterGraphTokenFilter build() {
            this._checkSingleUse();
            return new WordDelimiterGraphTokenFilter(this);
        }
    }
}

