/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import java.util.Locale;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.reactor.impl.IOHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomIOHandler
extends IOHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(CustomIOHandler.class);
    private final String name;

    public CustomIOHandler(String name) {
        this.name = name;
    }

    public void onTransportClosed(Event event) {
        Transport transport = event.getTransport();
        Connection connection = event.getConnection();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onTransportClosed name[%s], hostname[%s]", this.name, connection != null ? connection.getHostname() : "n/a"));
        }
        if (transport != null && connection != null && connection.getTransport() != null) {
            transport.unbind();
        }
    }
}

