import { z } from 'zod';
import { parseSchema } from './parse-schema';
import { half } from '../utils/half';
const originalIndex = Symbol('Original index');
const ensureOriginalIndex = (arr) => {
    const newArr = [];
    for (let i = 0; i < arr.length; i++) {
        const item = arr[i];
        if (typeof item === 'boolean') {
            newArr.push(item ? { [originalIndex]: i } : { [originalIndex]: i, not: {} });
        }
        else if (originalIndex in item) {
            return arr;
        }
        else {
            newArr.push({ ...item, [originalIndex]: i });
        }
    }
    return newArr;
};
export function parseAllOf(jsonSchema, refs) {
    if (jsonSchema.allOf.length === 0) {
        return z.never();
    }
    if (jsonSchema.allOf.length === 1) {
        const item = jsonSchema.allOf[0];
        return parseSchema(item, {
            ...refs,
            path: [...refs.path, 'allOf', item[originalIndex]],
        });
    }
    const [left, right] = half(ensureOriginalIndex(jsonSchema.allOf));
    return z.intersection(parseAllOf({ allOf: left }, refs), parseAllOf({ allOf: right }, refs));
}
