"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const NodeCrypto_1 = require("./NodeCrypto");
const NodeFilesystem_1 = require("./NodeFilesystem");
const NodeInfo_1 = require("./NodeInfo");
const NodeRequests_1 = require("./NodeRequests");
class NodePlatform {
    constructor(options) {
        this.fileSystem = new NodeFilesystem_1.default();
        this.crypto = new NodeCrypto_1.default();
        this.info = new NodeInfo_1.default(options);
        this.requests = new NodeRequests_1.default(options.tlsParams, options.proxyOptions, options.logger, options.enableEventCompression);
    }
}
exports.default = NodePlatform;
//# sourceMappingURL=NodePlatform.js.map