"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInitialState = exports.createEmptyState = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEmptyState = () => {
  return new WorkflowStateImpl();
};
exports.createEmptyState = createEmptyState;
const createInitialState = ({
  inputs
}) => {
  const state = createEmptyState();
  Object.entries(inputs).forEach(([key, value]) => {
    state.set(key, value);
  });
  return state;
};
exports.createInitialState = createInitialState;
class WorkflowStateImpl {
  constructor() {
    (0, _defineProperty2.default)(this, "_state", new Map());
  }
  has(key) {
    return this._state.has(key);
  }
  get(key) {
    if (!this._state.has(key)) {
      throw new Error(`Key ${key} not found in state`);
    }
    return this._state.get(key);
  }
  getKeys() {
    return [...this._state.keys()];
  }
  set(key, value) {
    this._state.set(key, value);
  }
}