"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNoopNodeEventReporter = exports.createNodeEventReporter = exports.convertNodeProgressionEvent = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createNoopNodeEventReporter = () => {
  return {
    reportProgress: () => {}
  };
};
exports.createNoopNodeEventReporter = createNoopNodeEventReporter;
const createNodeEventReporter = ({
  onEvent,
  meta
}) => {
  return {
    reportProgress: event => {
      onEvent(convertNodeProgressionEvent({
        event,
        meta
      }));
    }
  };
};
exports.createNodeEventReporter = createNodeEventReporter;
const convertNodeProgressionEvent = ({
  event,
  meta
}) => {
  return {
    eventType: 'node_progression',
    label: event.label,
    data: event.data,
    meta
  };
};
exports.convertNodeProgressionEvent = convertNodeProgressionEvent;