"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMockWorkflowRunnerInternalContext = exports.createInternalScopedRunnerMock = void 0;
var _loggingMocks = require("@kbn/logging-mocks");
var _mocks = require("@kbn/core/server/mocks");
var _models = require("./models");
var _tools = require("./tools");
var _execution_state = require("./execution_state");
var _registries = require("./registries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createInternalScopedRunnerMock = () => {
  return {
    runWorkflow: jest.fn(),
    runNode: jest.fn()
  };
};
exports.createInternalScopedRunnerMock = createInternalScopedRunnerMock;
const createMockWorkflowRunnerInternalContext = () => {
  const logger = _loggingMocks.loggerMock.create();
  const request = _mocks.httpServerMock.createKibanaRequest();
  const modelProvider = (0, _models.createModelProviderMock)();
  const executionState = (0, _execution_state.createExecutionState)();
  const esClusterClient = _mocks.elasticsearchServiceMock.createScopedClusterClient();
  const toolProvider = (0, _tools.createToolProviderMock)();
  const workflowRegistry = (0, _registries.createMockRegistry)();
  const nodeRegistry = (0, _registries.createMockRegistry)();
  const runner = createInternalScopedRunnerMock();
  const eventHandler = jest.fn();
  return {
    request,
    logger,
    modelProvider,
    esClusterClient,
    executionState,
    toolProvider,
    workflowRegistry,
    nodeRegistry,
    getRunner: () => runner,
    eventHandler
  };
};
exports.createMockWorkflowRunnerInternalContext = createMockWorkflowRunnerInternalContext;