"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParallelSequencesNodeTypeDefinition = void 0;
var _wcFrameworkTypesCommon = require("@kbn/wc-framework-types-common");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getParallelSequencesNodeTypeDefinition = () => {
  return {
    id: _wcFrameworkTypesCommon.NodeType.parallelSequences,
    name: 'Parallel sequences',
    description: 'Execute multiple node sequences in parallel',
    factory: context => {
      return {
        run: async ({
          input,
          state
        }) => {
          const {
            services: {
              workflowRunner
            }
          } = context;

          // no interpolation - we let the underlying nodes do it on their own
          const {
            branches
          } = input;
          await Promise.all(branches.map(branch => {
            return (0, _utils.runNodeSequence)({
              sequence: branch.steps,
              runner: workflowRunner,
              state
            });
          }));
        }
      };
    }
  };
};
exports.getParallelSequencesNodeTypeDefinition = getParallelSequencesNodeTypeDefinition;