"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workflowSoTypeName = exports.workflowSoType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const workflowSoTypeName = exports.workflowSoTypeName = 'onechat_workflow';
const workflowSoType = exports.workflowSoType = {
  name: workflowSoTypeName,
  hidden: true,
  namespaceType: 'multiple-isolated',
  mappings: {
    dynamic: false,
    properties: {
      workflow_id: {
        type: 'keyword'
      },
      user_id: {
        type: 'keyword'
      },
      categories: {
        type: 'keyword'
      },
      access_control: {
        properties: {
          public: {
            type: 'boolean'
          }
        }
      }
    }
  }
};