"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHandlerWrapper = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHandlerWrapper = ({
  logger
}) => handler => {
  return (ctx, req, res) => {
    try {
      return handler(ctx, req, res);
    } catch (e) {
      var _e$statusCode;
      logger.error(e);
      return res.customError({
        body: {
          message: e.message
        },
        statusCode: (_e$statusCode = e.statusCode) !== null && _e$statusCode !== void 0 ? _e$statusCode : 500
      });
    }
  };
};
exports.getHandlerWrapper = getHandlerWrapper;