"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerWorkflowsRoutes = void 0;
var _configSchema = require("@kbn/config-schema");
var _features = require("../../common/features");
var _wrap_handler = require("./wrap_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerWorkflowsRoutes = ({
  router,
  logger,
  getServices
}) => {
  const wrapHandler = (0, _wrap_handler.getHandlerWrapper)({
    logger
  });
  router.get({
    path: '/internal/workchat-framework/workflows/{workflowId}',
    security: {
      authz: {
        requiredPrivileges: [_features.apiCapabilities.useWorkchatFramework]
      }
    },
    validate: {
      params: _configSchema.schema.object({
        workflowId: _configSchema.schema.string()
      })
    }
  }, wrapHandler(async (ctx, request, response) => {
    const {
      workflowId
    } = request.params;
    const {
      workflowService
    } = getServices();
    const scopedService = await workflowService.asScoped({
      request
    });
    const workflow = await scopedService.get(workflowId);
    return response.ok({
      body: workflow
    });
  }));
};
exports.registerWorkflowsRoutes = registerWorkflowsRoutes;