"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18nReact = require("@kbn/i18n-react");
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _app_services_context = require("./context/app_services_context");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mountApp = async ({
  core,
  plugins,
  services,
  element,
  history
}) => {
  const kibanaServices = {
    ...core,
    plugins
  };
  const queryClient = new _reactQuery.QueryClient();
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: kibanaServices
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_app_services_context.AppServicesContext.Provider, {
    value: services
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: core
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_routes.AppRoutes, null)))))))), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
};
exports.mountApp = mountApp;