"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBuilder = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create a savedObject filter builder for given SO type.
 */
const createBuilder = soType => {
  const fieldPath = fieldName => `${soType}.attributes.${fieldName}`;
  const fieldValue = value => `${value}`;
  const or = (...clauses) => {
    return {
      toKQL: () => clauses.map(clause => '(' + clause.toKQL() + ')').join(' OR ')
    };
  };
  const and = (...clauses) => {
    return {
      toKQL: () => clauses.map(clause => '(' + clause.toKQL() + ')').join(' AND ')
    };
  };
  const equals = (name, value) => {
    return {
      toKQL: () => `${fieldPath(name)}: ${fieldValue(value)}`
    };
  };
  return {
    or,
    and,
    equals
  };
};
exports.createBuilder = createBuilder;