"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractCitations = void 0;
var _messages = require("@langchain/core/messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extract the content reference from the tool call messages contains some.
 */
const extractCitations = ({
  messages
}) => {
  const refs = [];
  messages.forEach(message => {
    var _message$artifact;
    // TODO: shall we fallback to check content if no artifact to make sure?
    if ((0, _messages.isToolMessage)(message) && (_message$artifact = message.artifact) !== null && _message$artifact !== void 0 && _message$artifact.citations) {
      refs.push(...message.artifact.citations);
    }
  });
  return refs;
};
exports.extractCitations = extractCitations;