"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTracers = void 0;
var _langsmith = require("./langsmith");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTracers = ({
  config
}) => {
  var _config$langsmith;
  const tracers = [];
  if (config !== null && config !== void 0 && (_config$langsmith = config.langsmith) !== null && _config$langsmith !== void 0 && _config$langsmith.enabled) {
    tracers.push((0, _langsmith.getLangsmithTracer)({
      apiKey: config.langsmith.apiKey,
      apiUrl: config.langsmith.apiUrl,
      project: config.langsmith.project
    }));
  }
  return tracers;
};
exports.getTracers = getTracers;