"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepDoneToolName = exports.stepDoneTool = void 0;
var _zod = require("@kbn/zod");
var _tools = require("@langchain/core/tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stepDoneToolName = exports.stepDoneToolName = 'STEP_DONE';
const stepDoneTool = () => {
  return new _tools.DynamicStructuredTool({
    name: stepDoneToolName,
    description: 'use this tool to notify that you want to transition to the next step',
    schema: _zod.z.object({}),
    func: () => {
      throw new Error(`${stepDoneToolName} was called and shouldn't have`);
    }
  });
};
exports.stepDoneTool = stepDoneTool;