"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runSearchAgent = exports.getSearchAgentCaller = void 0;
var _search_agent_graph = require("./search_agent_graph");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSearchAgentCaller = deps => ({
  query,
  context
}) => {
  return runSearchAgent({
    query,
    context,
    ...deps
  });
};
exports.getSearchAgentCaller = getSearchAgentCaller;
const runSearchAgent = async ({
  query,
  context,
  toolsProvider,
  chatModel,
  logger
}) => {
  const searchAgentGraph = await (0, _search_agent_graph.createSearchAgentGraph)({
    chatModel,
    toolsProvider,
    logger
  });
  const finalState = await searchAgentGraph.withConfig({
    tags: [`agent:search_agent`]
  }).invoke({
    searchQuery: query,
    searchContext: context
  }, {
    recursionLimit: 20,
    runName: 'searchAgentGraph',
    metadata: {
      graphName: _constants.graphNames.searchAgent
    }
  });
  const {
    summary,
    citations
  } = finalState;
  return {
    summary,
    citations
  };
};
exports.runSearchAgent = runSearchAgent;