"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toLangchainTool = toLangchainTool;
var _tools = require("@langchain/core/tools");
var _jsonSchemaToZod = require("@n8n/json-schema-to-zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toLangchainTool({
  tool,
  session,
  logger
}) {
  const schema = (0, _jsonSchemaToZod.jsonSchemaToZod)(tool.inputSchema);
  return (0, _tools.tool)(async input => {
    try {
      const result = await session.executeTool(tool.name, input);
      return JSON.stringify(result);
    } catch (e) {
      logger.warn(`error calling tool ${tool.name}: ${e.message}`);
      throw e;
    }
  }, {
    name: tool.name,
    description: tool.description,
    schema
  });
}